/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples.runnable;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.client.features.Messaging;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.datatype.json.JSON;
import com.pushtechnology.diffusion.examples.runnable.AbstractClient;
import com.pushtechnology.diffusion.examples.runnable.ConsumingJson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReceivingJson
extends AbstractClient {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumingJson.class);

    public ReceivingJson(String url, String principal) {
        super(url, principal);
    }

    @Override
    public void onConnected(Session session) {
        Messaging messaging = (Messaging)session.feature(Messaging.class);
        messaging.addRequestHandler("json", JSON.class, JSON.class, (Messaging.RequestHandler)new Messaging.RequestHandler<JSON, JSON>(){

            public void onRequest(JSON request, Messaging.RequestHandler.RequestContext context, Messaging.RequestHandler.Responder<JSON> responder) {
                LOG.info("Received request {}", (Object)request);
                responder.respond((Object)Diffusion.dataTypes().json().fromJsonString("true"));
            }

            public void onClose() {
                LOG.info("RequestHandler closed");
            }

            public void onError(ErrorReason errorReason) {
                LOG.info("RequestHandler error: {}", (Object)errorReason);
            }
        }, new String[0]);
    }

    public static void main(String[] args) throws InterruptedException {
        ReceivingJson client = new ReceivingJson("ws://diffusion.example.com:80", "auth");
        client.start("auth_secret");
        client.waitForStopped();
    }
}

