/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.manual;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.control.RemoteServers;
import com.pushtechnology.diffusion.client.session.Session;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteServersFeature {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteServersFeature.class);
    private Session session;

    public void createRemoteServer() throws Exception {
        RemoteServers.RemoteServer server = (RemoteServers.RemoteServer)((RemoteServers)this.session.feature(RemoteServers.class)).createRemoteServer(Diffusion.newRemoteServerBuilder().principal("admin").credentials(Diffusion.credentials().password("password")).create("Server_1", "ws://remote_server:80")).get(5L, TimeUnit.SECONDS);
    }

    public void checkRemoteServer() throws Exception {
        RemoteServers.CheckRemoteServerResult result = (RemoteServers.CheckRemoteServerResult)((RemoteServers)this.session.feature(RemoteServers.class)).checkRemoteServer("Server_1").get(5L, TimeUnit.SECONDS);
        switch (result.getConnectionState()) {
            case CONNECTED: {
                LOG.info("Connected and in use");
                break;
            }
            case FAILED: {
                LOG.info("Failed with " + result.getFailureMessage());
                break;
            }
            case INACTIVE: {
                LOG.info("Can connect but not currently connected as not in use");
                break;
            }
            case MISSING: {
                LOG.info("No such remote server");
                break;
            }
            case RETRYING: {
                LOG.info("Failed with " + result.getFailureMessage() + " but retry is scheduled");
                break;
            }
        }
    }

    public void listRemoteServers() throws Exception {
        List servers = (List)((RemoteServers)this.session.feature(RemoteServers.class)).listRemoteServers().get(5L, TimeUnit.SECONDS);
    }

    public void removeRemoteServer() throws Exception {
        ((RemoteServers)this.session.feature(RemoteServers.class)).removeRemoteServer("Server_1").get(5L, TimeUnit.SECONDS);
    }
}

