/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.Topics;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.datatype.json.JSON;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientConsumingJSONTopics {
    private static final Logger LOG = LoggerFactory.getLogger(ClientConsumingJSONTopics.class);
    private static final String ROOT_TOPIC = "FX";
    private static final String TOPIC_SELECTOR = String.format("?%s/", "FX");
    private final RatesListener listener;
    private final Session session;

    public ClientConsumingJSONTopics(String serverUrl, RatesListener listener) {
        this.listener = Objects.requireNonNull(listener);
        this.session = Diffusion.sessions().principal("client").password("password").open(serverUrl);
        Topics topics = (Topics)this.session.feature(Topics.class);
        topics.addStream(TOPIC_SELECTOR, JSON.class, (Topics.ValueStream)new RatesStream());
        topics.subscribe(TOPIC_SELECTOR).whenComplete((voidResult, exception) -> {
            if (exception != null) {
                LOG.info("subscription failed", exception);
            }
        });
    }

    public void close() {
        this.session.close();
    }

    private static String pathToCurrency(String path) {
        return path.substring(path.indexOf(47) + 1);
    }

    private final class RatesStream
    extends Topics.ValueStream.Default<JSON> {
        private final CBORFactory factory = new CBORFactory();
        private final ObjectMapper mapper = new ObjectMapper();
        private final TypeReference<Map<String, BigDecimal>> typeReference = new TypeReference<Map<String, BigDecimal>>(){};

        private RatesStream() {
        }

        public void onValue(String topicPath, TopicSpecification specification, JSON oldValue, JSON newValue) {
            try {
                CBORParser parser = this.factory.createParser(newValue.asInputStream());
                Map map = (Map)this.mapper.readValue((JsonParser)parser, this.typeReference);
                String currency = ClientConsumingJSONTopics.pathToCurrency(topicPath);
                ClientConsumingJSONTopics.this.listener.onNewRates(currency, map);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        public void onUnsubscription(String topicPath, TopicSpecification specification, Topics.UnsubscribeReason reason) {
            String currency = ClientConsumingJSONTopics.pathToCurrency(topicPath);
            ClientConsumingJSONTopics.this.listener.onRatesRemoved(currency);
        }
    }

    public static interface RatesListener {
        public void onNewRates(String var1, Map<String, BigDecimal> var2);

        public void onRatesRemoved(String var1);
    }
}

