/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.Pings;
import com.pushtechnology.diffusion.client.session.Session;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public final class ClientUsingPings {
    private final Session session;
    private final Pings pings;

    public ClientUsingPings(String serverUrl) {
        this.session = Diffusion.sessions().principal("client").password("password").open(serverUrl);
        this.pings = (Pings)this.session.feature(Pings.class);
    }

    public long ping() throws InterruptedException, ExecutionException {
        return ((Pings.PingDetails)this.pings.pingServer().get()).getRoundTripTime();
    }

    public CompletableFuture<Long> pingAsync() {
        return this.pings.pingServer().thenApply(Pings.PingDetails::getRoundTripTime);
    }

    public void close() {
        this.session.close();
    }
}

