/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.Topics;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUsingSessionLocks {
    private static final Logger LOG = LoggerFactory.getLogger(ClientUsingSessionLocks.class);
    private static final String LOCK_NAME = "lockA";
    private static final String TOPIC_PATH = "topicA";
    private final Session session;
    private final Topics.ValueStream<String> stream = new LogUpdates();

    public ClientUsingSessionLocks(String serverURL) {
        this.session = Diffusion.sessions().principal("client").password("password").open(serverURL);
    }

    public void start() {
        this.session.addListener((s, oldState, newState) -> {
            if (newState.isClosed()) {
                this.onLockLost();
            }
        });
        this.requestLock();
    }

    private void requestLock() {
        this.session.lock(LOCK_NAME, Session.SessionLockScope.UNLOCK_ON_CONNECTION_LOSS).thenAccept(lock -> this.onLockAcquired());
    }

    private void onLockAcquired() {
        Topics topics = (Topics)this.session.feature(Topics.class);
        topics.subscribe(TOPIC_PATH);
        topics.addStream(TOPIC_PATH, String.class, this.stream);
    }

    private void onLockLost() {
        Topics topics = (Topics)this.session.feature(Topics.class);
        topics.removeStream(this.stream);
        topics.unsubscribe(TOPIC_PATH);
        this.requestLock();
    }

    public void close() {
        this.session.close();
    }

    private static class LogUpdates
    extends Topics.ValueStream.Default<String> {
        private LogUpdates() {
        }

        public void onSubscription(String topicPath, TopicSpecification specification) {
            LOG.info("onSubscription({})", (Object)topicPath);
        }

        public void onUnsubscription(String topicPath, TopicSpecification specification, Topics.UnsubscribeReason reason) {
            LOG.info("onUnsubscription({})", (Object)topicPath);
        }

        public void onValue(String topicPath, TopicSpecification specification, String oldValue, String newValue) {
            LOG.info("onValue({}, {})", (Object)topicPath, (Object)newValue);
        }
    }
}

