/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.session.reconnect.ReconnectionStrategy;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ClientWithReconnectionStrategy {
    private volatile int retries = 0;

    public ClientWithReconnectionStrategy() {
        int maximumTimeoutDuration = 600000;
        long maximumAttemptInterval = 60000L;
        ReconnectionStrategy reconnectionStrategy = new ReconnectionStrategy(){
            private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

            public void performReconnection(final ReconnectionStrategy.ReconnectionAttempt reconnection) {
                long exponentialWaitTime = Math.min((long)Math.pow(2.0, ClientWithReconnectionStrategy.this.retries++) * 100L, 60000L);
                this.scheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        reconnection.start();
                    }
                }, exponentialWaitTime, TimeUnit.MILLISECONDS);
            }
        };
        Session session = Diffusion.sessions().reconnectionTimeout(600000).reconnectionStrategy(reconnectionStrategy).open("ws://diffusion.example.com:80");
        session.addListener(new Session.Listener(){

            public void onSessionStateChanged(Session session, Session.State oldState, Session.State newState) {
                if (newState == Session.State.RECOVERING_RECONNECT) {
                    // empty if block
                }
                if (newState == Session.State.CONNECTED_ACTIVE) {
                    ClientWithReconnectionStrategy.this.retries = 0;
                }
                if (oldState == Session.State.RECOVERING_RECONNECT) {
                    // empty if block
                }
            }
        });
    }
}

