/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.callbacks.Stream;
import com.pushtechnology.diffusion.client.features.control.clients.AuthenticationControl;
import com.pushtechnology.diffusion.client.security.authentication.Authenticator;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.types.Credentials;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class ControlAuthenticationClient {
    private ControlAuthenticationClient() {
    }

    public static void main(String[] args) throws Exception {
        Session session = Diffusion.sessions().principal("admin").password("password").open("ws://diffusion.example.com:80");
        ((AuthenticationControl)session.feature(AuthenticationControl.class)).setAuthenticationHandler("after-system-handler", (AuthenticationControl.ControlAuthenticator)new ExampleControlAuthenticationHandler()).get(10L, TimeUnit.SECONDS);
        while (true) {
            Thread.sleep(60000L);
        }
    }

    private static class ExampleControlAuthenticationHandler
    extends Stream.Default
    implements AuthenticationControl.ControlAuthenticator {
        private static final Map<String, byte[]> PASSWORDS = new HashMap<String, byte[]>();

        private ExampleControlAuthenticationHandler() {
        }

        public void authenticate(String principal, Credentials credentials, Map<String, String> sessionProperties, Map<String, String> proposedProperties, Authenticator.Callback callback) {
            byte[] passwordBytes = PASSWORDS.get(principal);
            if (passwordBytes != null && credentials.getType() == Credentials.Type.PLAIN_PASSWORD && Arrays.equals(credentials.toBytes(), passwordBytes)) {
                if ("manager".equals(principal)) {
                    callback.allow(proposedProperties);
                } else if ("brian".equals(principal)) {
                    HashMap<String, String> result = new HashMap<String, String>(proposedProperties);
                    Set roles = Diffusion.stringToRoles((String)sessionProperties.get("$Roles"));
                    roles.add("super");
                    result.put("$Roles", Diffusion.rolesToString((Set)roles));
                    callback.allow(result);
                } else {
                    callback.allow();
                }
            } else {
                callback.deny();
            }
        }

        static {
            PASSWORDS.put("manager", "password".getBytes(Charset.forName("UTF-8")));
            PASSWORDS.put("guest", "asecret".getBytes(Charset.forName("UTF-8")));
            PASSWORDS.put("brian", "boru".getBytes(Charset.forName("UTF-8")));
            PASSWORDS.put("another", "apassword".getBytes(Charset.forName("UTF-8")));
        }
    }
}

