/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.TopicUpdate;
import com.pushtechnology.diffusion.client.features.control.topics.TopicControl;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.datatype.json.JSON;
import com.pushtechnology.diffusion.datatype.json.JSONDataType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ControlClientUpdatingJSONTopicsWithCBOR {
    private static final String ROOT_TOPIC = "FX";
    private final Session session;
    private final TopicControl topicControl;
    private final TopicUpdate topicUpdate;
    private final TopicSpecification topicSpecification;
    private final CBORFactory cborFactory = new CBORFactory();
    private final JSONDataType jsonDataType = Diffusion.dataTypes().json();

    public ControlClientUpdatingJSONTopicsWithCBOR(String serverUrl) throws InterruptedException, ExecutionException, TimeoutException {
        this.cborFactory.setCodec((ObjectCodec)new ObjectMapper());
        this.session = Diffusion.sessions().principal("control").password("password").open(serverUrl);
        this.topicControl = (TopicControl)this.session.feature(TopicControl.class);
        this.topicUpdate = (TopicUpdate)this.session.feature(TopicUpdate.class);
        this.topicSpecification = Diffusion.newTopicSpecification((TopicType)TopicType.JSON);
        TopicSpecification specification = this.topicSpecification.withProperty("REMOVAL", "When this session closes remove '?FX//'");
        this.topicControl.addTopic(ROOT_TOPIC, specification).get(5L, TimeUnit.SECONDS);
    }

    public void addRates(String currency, Map<String, String> value) throws IllegalArgumentException, UnsupportedOperationException, IOException {
        this.topicUpdate.addAndSet(ControlClientUpdatingJSONTopicsWithCBOR.rateTopicName(currency), this.topicSpecification, JSON.class, (Object)this.mapToJSON(value));
    }

    public CompletableFuture<?> changeRates(String currency, Map<String, String> values) throws IOException {
        return this.topicUpdate.set(ControlClientUpdatingJSONTopicsWithCBOR.rateTopicName(currency), JSON.class, (Object)this.mapToJSON(values));
    }

    private JSON mapToJSON(Map<String, String> values) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CBORGenerator generator = this.cborFactory.createGenerator((OutputStream)baos);
        generator.writeObject(values);
        return this.jsonDataType.readValue(baos.toByteArray());
    }

    public CompletableFuture<?> removeRates(String currency) {
        String topicName = ControlClientUpdatingJSONTopicsWithCBOR.rateTopicName(currency);
        return this.topicControl.removeTopics(topicName);
    }

    public void close() {
        this.session.close();
    }

    private static String rateTopicName(String currency) {
        return String.format("%s/%s", ROOT_TOPIC, Objects.requireNonNull(currency));
    }
}

