/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.TopicUpdate;
import com.pushtechnology.diffusion.client.features.control.topics.TopicControl;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.datatype.recordv2.RecordV2;
import com.pushtechnology.diffusion.datatype.recordv2.RecordV2DataType;
import com.pushtechnology.diffusion.datatype.recordv2.model.MutableRecordModel;
import com.pushtechnology.diffusion.datatype.recordv2.schema.Schema;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ControlClientUpdatingRecordV2Topics {
    private static final String ROOT_TOPIC = "FX";
    private final Session session;
    private final TopicControl topicControl;
    private final TopicSpecification topicSpecification;
    private final Schema schema;
    private final RecordV2DataType dataType;

    public ControlClientUpdatingRecordV2Topics(String serverUrl, boolean withSchema) throws InterruptedException, ExecutionException, TimeoutException {
        this.session = Diffusion.sessions().principal("control").password("password").open(serverUrl);
        this.topicControl = (TopicControl)this.session.feature(TopicControl.class);
        TopicSpecification specification = Diffusion.newTopicSpecification((TopicType)TopicType.STRING).withProperty("REMOVAL", "when this session closes remove '?FX//'");
        this.topicControl.addTopic(ROOT_TOPIC, specification).get(5L, TimeUnit.SECONDS);
        this.dataType = Diffusion.dataTypes().recordV2();
        if (withSchema) {
            this.schema = this.dataType.schemaBuilder().record("Rates").decimal("Bid", 5).decimal("Ask", 5).build();
            this.topicSpecification = Diffusion.newTopicSpecification((TopicType)TopicType.RECORD_V2).withProperty("SCHEMA", this.schema.asJSONString());
        } else {
            this.schema = null;
            this.topicSpecification = Diffusion.newTopicSpecification((TopicType)TopicType.RECORD_V2);
        }
    }

    public void addRateTopic(String currency, String targetCurrency) throws InterruptedException, ExecutionException, TimeoutException {
        this.topicControl.addTopic(ControlClientUpdatingRecordV2Topics.rateTopicName(currency, targetCurrency), this.topicSpecification).get(5L, TimeUnit.SECONDS);
    }

    public CompletableFuture<?> setRate(String currency, String targetCurrency, String bid, String ask) {
        RecordV2 value;
        if (this.schema == null) {
            value = this.dataType.valueBuilder().addFields(new String[]{bid, ask}).build();
        } else {
            MutableRecordModel model = this.schema.createMutableModel();
            model.set("Bid", bid);
            model.set("Ask", ask);
            value = model.asValue();
        }
        return ((TopicUpdate)this.session.feature(TopicUpdate.class)).set(ControlClientUpdatingRecordV2Topics.rateTopicName(currency, targetCurrency), RecordV2.class, (Object)value);
    }

    public void removeRate(String currency, String targetCurrency) throws InterruptedException, ExecutionException, TimeoutException {
        this.topicControl.removeTopics(ControlClientUpdatingRecordV2Topics.rateTopicName(currency, targetCurrency)).get(5L, TimeUnit.SECONDS);
    }

    public void removeCurrency(String currency) throws InterruptedException, ExecutionException, TimeoutException {
        this.topicControl.removeTopics(String.format("?%s/%s//", ROOT_TOPIC, currency)).get(5L, TimeUnit.SECONDS);
    }

    public void close() throws InterruptedException {
        this.session.close();
    }

    private static String rateTopicName(String currency, String targetCurrency) {
        return String.format("%s/%s/%s", ROOT_TOPIC, currency, targetCurrency);
    }
}

