/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.TopicUpdate;
import com.pushtechnology.diffusion.client.features.control.topics.TopicControl;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public final class ControlClientUpdatingSimpleTopics {
    private static final String TOPIC = "StringTopic";
    private final Session session;

    public ControlClientUpdatingSimpleTopics(String serverUrl) throws Exception {
        this.session = Diffusion.sessions().principal("control").password("password").open(serverUrl);
        TopicControl topicControl = (TopicControl)this.session.feature(TopicControl.class);
        TopicSpecification specification = Diffusion.newTopicSpecification((TopicType)TopicType.STRING).withProperty("REMOVAL", "when this session closes remove '?StringTopic//'");
        topicControl.addTopic(TOPIC, specification).get(5L, TimeUnit.SECONDS);
    }

    public CompletableFuture<?> update(String value) {
        return ((TopicUpdate)this.session.feature(TopicUpdate.class)).set(TOPIC, String.class, (Object)value);
    }

    public void close() {
        this.session.close();
    }
}

