/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.client.features.Messaging;
import com.pushtechnology.diffusion.client.session.Session;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ControlClientUsingFiltersAndProperties {
    private final Session session;
    private final Messaging messaging;
    private static final Messaging.FilteredRequestCallback<String> FILTERED_CALLBACK = new Messaging.FilteredRequestCallback.Default();

    public ControlClientUsingFiltersAndProperties(String serverUrl) throws InterruptedException, ExecutionException, TimeoutException {
        this.session = Diffusion.sessions().principal("control").password("password").open(serverUrl);
        this.messaging = (Messaging)this.session.feature(Messaging.class);
        this.messaging.addRequestHandler("foo", String.class, String.class, (Messaging.RequestHandler)new BroadcastHandler(), new String[]{"JobTitle"}).get(5L, TimeUnit.SECONDS);
    }

    public void close() {
        this.session.close();
    }

    private class BroadcastHandler
    implements Messaging.RequestHandler<String, String> {
        private BroadcastHandler() {
        }

        public void onRequest(String request, Messaging.RequestHandler.RequestContext context, Messaging.RequestHandler.Responder<String> responder) {
            if ("Manager".equals(context.getSessionProperties().get("JobTitle"))) {
                ControlClientUsingFiltersAndProperties.this.messaging.sendRequestToFilter("JobTitle is 'Staff'", "foo", (Object)request, String.class, String.class, FILTERED_CALLBACK).thenAccept(sentTo -> responder.respond((Object)("Sent to " + sentTo + " staff")));
            } else {
                responder.respond((Object)"Not sent");
            }
        }

        public void onClose() {
        }

        public void onError(ErrorReason errorReason) {
        }
    }
}

