/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.TopicUpdate;
import com.pushtechnology.diffusion.client.features.control.topics.views.TopicViews;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.datatype.json.JSON;
import com.pushtechnology.diffusion.datatype.json.JSONDataType;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;

public final class CreateSecondaryKeys
implements AutoCloseable {
    private final Session session;
    private final TopicUpdate topicUpdate;
    private final TopicViews topicViews;
    private final JSONDataType jsonDataType = Diffusion.dataTypes().json();
    private final AtomicInteger idGenerator = new AtomicInteger(0);

    public CreateSecondaryKeys(String serverUrl) {
        this.session = Diffusion.sessions().principal("control").password("password").open(serverUrl);
        this.topicUpdate = (TopicUpdate)this.session.feature(TopicUpdate.class);
        this.topicViews = (TopicViews)this.session.feature(TopicViews.class);
    }

    public CompletableFuture<?> createEvent(String country, String homeTeam, String awayTeam) {
        String path = String.format("Football/All/%d", this.idGenerator.getAndIncrement());
        JSON value = this.jsonDataType.fromJsonString(String.format("{\"country\":\"%s\",\"home\":\"%s\",\"away\":\"%s\"}", country, homeTeam, awayTeam));
        return this.topicUpdate.addAndSet(path, Diffusion.newTopicSpecification((TopicType)TopicType.JSON), JSON.class, (Object)value);
    }

    public CompletableFuture<?> createSecondaryKeyByCountry() {
        return this.topicViews.createTopicView("football-by-country", "map '?Football/All/' to 'Football/<scalar(/country)>/<path(2)>'");
    }

    @Override
    public void close() {
        this.session.close();
    }
}

