/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.manual;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.datatype.recordv2.RecordV2DataType;
import com.pushtechnology.diffusion.datatype.recordv2.schema.Schema;
import com.pushtechnology.diffusion.datatype.recordv2.schema.SchemaBuilder;

public final class ClientCreatingRecordV2Schema {
    private final RecordV2DataType dataType = Diffusion.dataTypes().recordV2();

    public Schema createSimpleSchema() {
        SchemaBuilder builder = this.dataType.schemaBuilder();
        return builder.record("Record").string("string").integer("integer").decimal("decimal", 3).build();
    }

    public Schema createMultipleRecordsSchema() {
        SchemaBuilder builder = this.dataType.schemaBuilder();
        return builder.record("StringRecord").string("string").record("IntegerRecord").integer("integer").record("DecimalRecord").decimal("decimal", 3).build();
    }

    public Schema createFixedRepeatingRecordsSchema() {
        SchemaBuilder builder = this.dataType.schemaBuilder();
        return builder.record("RepeatingRecord", 10).string("string").build();
    }

    public Schema createVariableRepeatingRecordsSchema() {
        SchemaBuilder builder = this.dataType.schemaBuilder();
        return builder.record("FixedRecord", 5).string("a").record("RepeatingRecord", 0, -1).string("b").build();
    }

    public Schema createFixedRepeatingFieldsSchema() {
        SchemaBuilder builder = this.dataType.schemaBuilder();
        return builder.record("Record").string("repeatingString", 10).build();
    }

    public Schema createVariableRepeatingFieldsSchema() {
        SchemaBuilder builder = this.dataType.schemaBuilder();
        return builder.record("A").string("repeatingField", 2, 5).record("B").string("repeatingFieldUnlimited", 1, -1).build();
    }

    public Schema createNameAndAddressSchema() {
        SchemaBuilder builder = this.dataType.schemaBuilder();
        return builder.record("nameAndAddress").string("firstName").string("surname").integer("houseNumber").string("street").string("town").string("state").string("postCode").build();
    }
}

