/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.tutorials;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.TopicUpdate;
import com.pushtechnology.diffusion.client.features.Topics;
import com.pushtechnology.diffusion.client.features.control.topics.TopicControl;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.datatype.json.JSON;
import com.pushtechnology.diffusion.datatype.json.JSONDataType;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class PubSubExample {
    public static void main(String ... arguments) throws Exception {
        Session session = Diffusion.sessions().principal("admin").password("password").open("ws://localhost:8080");
        Topics topics = (Topics)session.feature(Topics.class);
        TopicControl topicControl = (TopicControl)session.feature(TopicControl.class);
        topics.addStream("counter", JSON.class, (Topics.ValueStream)new Topics.ValueStream.Default<JSON>(){

            public void onSubscription(String topicPath, TopicSpecification specification) {
                System.out.println("Subscribed to: " + topicPath);
            }

            public void onValue(String topicPath, TopicSpecification specification, JSON oldValue, JSON newValue) {
                System.out.println(topicPath + " : " + newValue.toJsonString());
            }
        });
        topics.subscribe("counter");
        topicControl.addTopic("counter", TopicType.JSON);
        JSONDataType jsonDataType = Diffusion.dataTypes().json();
        TopicUpdate topicUpdate = (TopicUpdate)session.feature(TopicUpdate.class);
        AtomicInteger i = new AtomicInteger(0);
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
            JSON value = jsonDataType.fromJsonString(String.format("{\"count\" : %d }", i.getAndIncrement()));
            topicUpdate.set("counter", JSON.class, (Object)value);
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }
}

