/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.handler.call;

import com.exsoloscript.challonge.handler.call.ChallongeApiCall;
import com.exsoloscript.challonge.handler.call.RetrofitChallongeApiCallFactory;
import com.exsoloscript.challonge.handler.retrofit.RetrofitMatchHandler;
import com.exsoloscript.challonge.handler.retrofit.RetrofitServiceProvider;
import com.exsoloscript.challonge.library.commons.lang3.StringUtils;
import com.exsoloscript.challonge.library.commons.lang3.Validate;
import com.exsoloscript.challonge.library.google.inject.Inject;
import com.exsoloscript.challonge.library.google.inject.Singleton;
import com.exsoloscript.challonge.model.Match;
import com.exsoloscript.challonge.model.enumeration.MatchState;
import com.exsoloscript.challonge.model.exception.ChallongeException;
import com.exsoloscript.challonge.model.query.MatchQuery;
import java.io.IOException;
import java.util.List;

@Singleton
public class MatchHandler {
    private RetrofitMatchHandler matchHandler;
    private RetrofitChallongeApiCallFactory factory;

    @Inject
    MatchHandler(RetrofitServiceProvider provider, RetrofitChallongeApiCallFactory factory) {
        this.matchHandler = provider.createService(RetrofitMatchHandler.class);
        this.factory = factory;
    }

    public ChallongeApiCall<List<Match>> getMatches(String tournament, Integer participantId, MatchState state) throws IOException, ChallongeException {
        Validate.isTrue(StringUtils.isNotBlank(tournament), "Tournament string is required", new Object[0]);
        return this.factory.createApiCall(this.matchHandler.getMatches(tournament, participantId, state));
    }

    public ChallongeApiCall<List<Match>> getMatches(String tournament) throws IOException, ChallongeException {
        return this.getMatches(tournament, null, null);
    }

    public ChallongeApiCall<Match> getMatch(String tournament, int matchId, boolean includeAttachments) throws IOException, ChallongeException {
        Validate.isTrue(StringUtils.isNotBlank(tournament), "Tournament string is required", new Object[0]);
        Validate.notNull(matchId, "Match id is required", new Object[0]);
        return this.factory.createApiCall(this.matchHandler.getMatch(tournament, matchId, includeAttachments ? 1 : 0));
    }

    public ChallongeApiCall<Match> updateMatch(String tournament, int matchId, MatchQuery match) throws IOException, ChallongeException {
        Validate.isTrue(StringUtils.isNotBlank(tournament), "Tournament string is required", new Object[0]);
        Validate.notNull(matchId, "Match id is required", new Object[0]);
        return this.factory.createApiCall(this.matchHandler.updateMatch(tournament, matchId, match));
    }
}

