/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.handler.retrofit;

import com.exsoloscript.challonge.ChallongeCredentials;
import com.exsoloscript.challonge.library.google.gson.Gson;
import com.exsoloscript.challonge.library.google.inject.Inject;
import com.exsoloscript.challonge.library.google.inject.Provider;
import com.exsoloscript.challonge.library.google.inject.Singleton;
import com.exsoloscript.challonge.library.squareup.okhttp3.OkHttpClient;
import com.exsoloscript.challonge.library.squareup.okhttp3.Request;
import com.exsoloscript.challonge.library.squareup.okhttp3.logging.HttpLoggingInterceptor;
import com.exsoloscript.challonge.library.squareup.retrofit2.Retrofit;
import com.exsoloscript.challonge.library.squareup.retrofit2.converter.gson.GsonConverterFactory;

@Singleton
public class RetrofitServiceProvider
implements Provider<Retrofit> {
    private Retrofit retrofit;

    @Inject
    private RetrofitServiceProvider(ChallongeCredentials credentials, Gson gson) {
        String baseUrl = "https://api.challonge.com/v1/";
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        httpClientBuilder.addInterceptor(chain -> {
            Request original = chain.request();
            Request.Builder requestBuilder = original.newBuilder().header("Authorization", credentials.toHttpAuthString()).header("Accept", "application/json").method(original.method(), original.body());
            Request request = requestBuilder.build();
            return chain.proceed(request);
        });
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(System.out::println);
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        this.retrofit = new Retrofit.Builder().client(httpClientBuilder.build()).baseUrl(baseUrl).addConverterFactory(GsonConverterFactory.create(gson)).build();
    }

    public <S> S createService(Class<S> serviceClass) {
        return this.retrofit.create(serviceClass);
    }

    @Override
    public Retrofit get() {
        return this.retrofit;
    }
}

