/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.library.google.common.collect;

import com.exsoloscript.challonge.library.google.common.annotations.GwtCompatible;
import com.exsoloscript.challonge.library.google.common.annotations.VisibleForTesting;
import com.exsoloscript.challonge.library.google.common.collect.Hashing;
import com.exsoloscript.challonge.library.google.common.collect.ImmutableList;
import com.exsoloscript.challonge.library.google.common.collect.ImmutableSet;
import com.exsoloscript.challonge.library.google.common.collect.Iterators;
import com.exsoloscript.challonge.library.google.common.collect.ObjectArrays;
import com.exsoloscript.challonge.library.google.common.collect.RegularImmutableAsList;
import com.exsoloscript.challonge.library.google.common.collect.UnmodifiableIterator;
import com.exsoloscript.challonge.library.javax.annotation.Nullable;

@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableSet<E>
extends ImmutableSet<E> {
    static final RegularImmutableSet<Object> EMPTY = new RegularImmutableSet(ObjectArrays.EMPTY_ARRAY, 0, null, 0);
    private final transient Object[] elements;
    @VisibleForTesting
    final transient Object[] table;
    private final transient int mask;
    private final transient int hashCode;

    RegularImmutableSet(Object[] elements, int hashCode, Object[] table, int mask) {
        this.elements = elements;
        this.table = table;
        this.mask = mask;
        this.hashCode = hashCode;
    }

    @Override
    public boolean contains(@Nullable Object target) {
        Object[] table = this.table;
        if (target == null || table == null) {
            return false;
        }
        int i = Hashing.smearedHash(target);
        Object candidate;
        while ((candidate = table[i &= this.mask]) != null) {
            if (candidate.equals(target)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.forArray(this.elements);
    }

    @Override
    int copyIntoArray(Object[] dst, int offset) {
        System.arraycopy(this.elements, 0, dst, offset, this.elements.length);
        return offset + this.elements.length;
    }

    @Override
    ImmutableList<E> createAsList() {
        return this.table == null ? ImmutableList.of() : new RegularImmutableAsList(this, this.elements);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    boolean isHashCodeFast() {
        return true;
    }
}

