/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.library.google.inject.internal;

import com.exsoloscript.challonge.library.aopalliance.intercept.MethodInterceptor;
import com.exsoloscript.challonge.library.google.common.base.Preconditions;
import com.exsoloscript.challonge.library.google.common.collect.ImmutableMap;
import com.exsoloscript.challonge.library.google.inject.internal.BytecodeGen;
import com.exsoloscript.challonge.library.google.inject.internal.ConstructionProxy;
import com.exsoloscript.challonge.library.google.inject.internal.ConstructionProxyFactory;
import com.exsoloscript.challonge.library.google.inject.internal.cglib.core.$CodeGenerationException;
import com.exsoloscript.challonge.library.google.inject.internal.cglib.reflect.$FastClass;
import com.exsoloscript.challonge.library.google.inject.spi.InjectionPoint;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;

final class DefaultConstructionProxyFactory<T>
implements ConstructionProxyFactory<T> {
    private final InjectionPoint injectionPoint;

    DefaultConstructionProxyFactory(InjectionPoint injectionPoint) {
        this.injectionPoint = injectionPoint;
    }

    @Override
    public ConstructionProxy<T> create() {
        Constructor constructor = (Constructor)this.injectionPoint.getMember();
        try {
            $FastClass fc = BytecodeGen.newFastClassForMember(constructor);
            if (fc != null) {
                int index = fc.getIndex(constructor.getParameterTypes());
                Preconditions.checkArgument(index >= 0, "Could not find constructor %s in fast class", constructor);
                return new FastClassProxy(this.injectionPoint, constructor, fc, index);
            }
        }
        catch ($CodeGenerationException $CodeGenerationException) {
            // empty catch block
        }
        return new ReflectiveProxy(this.injectionPoint, constructor);
    }

    private static final class ReflectiveProxy<T>
    implements ConstructionProxy<T> {
        final Constructor<T> constructor;
        final InjectionPoint injectionPoint;

        ReflectiveProxy(InjectionPoint injectionPoint, Constructor<T> constructor) {
            if (!Modifier.isPublic(constructor.getDeclaringClass().getModifiers()) || !Modifier.isPublic(constructor.getModifiers())) {
                constructor.setAccessible(true);
            }
            this.injectionPoint = injectionPoint;
            this.constructor = constructor;
        }

        @Override
        public T newInstance(Object ... arguments) throws InvocationTargetException {
            try {
                return this.constructor.newInstance(arguments);
            }
            catch (InstantiationException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public InjectionPoint getInjectionPoint() {
            return this.injectionPoint;
        }

        @Override
        public Constructor<T> getConstructor() {
            return this.constructor;
        }

        @Override
        public ImmutableMap<Method, List<MethodInterceptor>> getMethodInterceptors() {
            return ImmutableMap.of();
        }
    }

    private static final class FastClassProxy<T>
    implements ConstructionProxy<T> {
        final InjectionPoint injectionPoint;
        final Constructor<T> constructor;
        final $FastClass fc;
        final int index;

        private FastClassProxy(InjectionPoint injectionPoint, Constructor<T> constructor, $FastClass fc, int index) {
            this.injectionPoint = injectionPoint;
            this.constructor = constructor;
            this.fc = fc;
            this.index = index;
        }

        @Override
        public T newInstance(Object ... arguments) throws InvocationTargetException {
            return (T)this.fc.newInstance(this.index, arguments);
        }

        @Override
        public InjectionPoint getInjectionPoint() {
            return this.injectionPoint;
        }

        @Override
        public Constructor<T> getConstructor() {
            return this.constructor;
        }

        @Override
        public ImmutableMap<Method, List<MethodInterceptor>> getMethodInterceptors() {
            return ImmutableMap.of();
        }
    }
}

