/*
 * Decompiled with CFR 0.152.
 */
package com.exsoloscript.challonge.library.squareup.okhttp3.internal.tls;

import com.exsoloscript.challonge.library.javax.net.ssl.SSLPeerUnverifiedException;
import com.exsoloscript.challonge.library.javax.net.ssl.X509TrustManager;
import com.exsoloscript.challonge.library.squareup.okhttp3.internal.tls.TrustRootIndex;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class CertificateChainCleaner {
    public abstract List<Certificate> clean(List<Certificate> var1, String var2) throws SSLPeerUnverifiedException;

    public static CertificateChainCleaner get(X509TrustManager trustManager) {
        try {
            Class<?> extensionsClass = Class.forName("android.net.http.X509TrustManagerExtensions");
            Constructor<?> constructor = extensionsClass.getConstructor(X509TrustManager.class);
            Object extensions = constructor.newInstance(trustManager);
            Method checkServerTrusted = extensionsClass.getMethod("checkServerTrusted", X509Certificate[].class, String.class, String.class);
            return new AndroidCertificateChainCleaner(extensions, checkServerTrusted);
        }
        catch (Exception e) {
            return new BasicCertificateChainCleaner(TrustRootIndex.get(trustManager));
        }
    }

    public static CertificateChainCleaner get(X509Certificate ... caCerts) {
        return new BasicCertificateChainCleaner(TrustRootIndex.get(caCerts));
    }

    static final class AndroidCertificateChainCleaner
    extends CertificateChainCleaner {
        private final Object x509TrustManagerExtensions;
        private final Method checkServerTrusted;

        AndroidCertificateChainCleaner(Object x509TrustManagerExtensions, Method checkServerTrusted) {
            this.x509TrustManagerExtensions = x509TrustManagerExtensions;
            this.checkServerTrusted = checkServerTrusted;
        }

        @Override
        public List<Certificate> clean(List<Certificate> chain, String hostname) throws SSLPeerUnverifiedException {
            try {
                X509Certificate[] certificates = chain.toArray(new X509Certificate[chain.size()]);
                return (List)this.checkServerTrusted.invoke(this.x509TrustManagerExtensions, certificates, "RSA", hostname);
            }
            catch (InvocationTargetException e) {
                SSLPeerUnverifiedException exception = new SSLPeerUnverifiedException(e.getMessage());
                exception.initCause((Throwable)e);
                throw exception;
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    static final class BasicCertificateChainCleaner
    extends CertificateChainCleaner {
        private static final int MAX_SIGNERS = 9;
        private final TrustRootIndex trustRootIndex;

        public BasicCertificateChainCleaner(TrustRootIndex trustRootIndex) {
            this.trustRootIndex = trustRootIndex;
        }

        @Override
        public List<Certificate> clean(List<Certificate> chain, String hostname) throws SSLPeerUnverifiedException {
            ArrayDeque<Certificate> queue = new ArrayDeque<Certificate>(chain);
            ArrayList<Certificate> result = new ArrayList<Certificate>();
            result.add((Certificate)queue.removeFirst());
            boolean foundTrustedCertificate = false;
            block0: for (int c = 0; c < 9; ++c) {
                X509Certificate toVerify = (X509Certificate)result.get(result.size() - 1);
                X509Certificate trustedCert = this.trustRootIndex.findByIssuerAndSignature(toVerify);
                if (trustedCert != null) {
                    if (result.size() > 1 || !toVerify.equals(trustedCert)) {
                        result.add(trustedCert);
                    }
                    if (this.verifySignature(trustedCert, trustedCert)) {
                        return result;
                    }
                    foundTrustedCertificate = true;
                    continue;
                }
                Iterator i = queue.iterator();
                while (i.hasNext()) {
                    X509Certificate signingCert = (X509Certificate)i.next();
                    if (!this.verifySignature(toVerify, signingCert)) continue;
                    i.remove();
                    result.add(signingCert);
                    continue block0;
                }
                if (foundTrustedCertificate) {
                    return result;
                }
                throw new SSLPeerUnverifiedException("Failed to find a trusted cert that signed " + toVerify);
            }
            throw new SSLPeerUnverifiedException("Certificate chain too long: " + result);
        }

        private boolean verifySignature(X509Certificate toVerify, X509Certificate signingCert) {
            if (!toVerify.getIssuerDN().equals(signingCert.getSubjectDN())) {
                return false;
            }
            try {
                toVerify.verify(signingCert.getPublicKey());
                return true;
            }
            catch (GeneralSecurityException verifyFailed) {
                return false;
            }
        }
    }
}

