/*
 * Decompiled with CFR 0.152.
 */
package com.github.advisedtesting.core.internal;

import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.aopalliance.intercept.MethodInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestContext.class);
    private static final ConcurrentHashMap<Class<? extends MethodInterceptor>, MethodInterceptor> INTECEPTORCLASS_TO_INSTANCE = new ConcurrentHashMap();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public TestContext() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                TestContext.this.close();
            }
        }));
    }

    public MethodInterceptor getAdviceFor(Annotation annotation, ClassLoader classLoader) {
        if (this.closed.get() || annotation == null) {
            return null;
        }
        Class<MethodInterceptor> adviceClass = this.extractAdviceClass(annotation, classLoader);
        if (adviceClass == null) {
            return null;
        }
        INTECEPTORCLASS_TO_INSTANCE.computeIfAbsent(adviceClass, a -> (MethodInterceptor)this.callZeroArguementConstructor(adviceClass));
        return INTECEPTORCLASS_TO_INSTANCE.get(adviceClass);
    }

    public void close() {
        if (!this.closed.getAndSet(true)) {
            for (MethodInterceptor advice : INTECEPTORCLASS_TO_INSTANCE.values()) {
                if (!Closeable.class.isAssignableFrom(advice.getClass())) continue;
                try {
                    ((Closeable)advice).close();
                }
                catch (IOException ex) {
                    LOGGER.error("Error closing advice methods", (Throwable)ex);
                }
            }
        }
    }

    public boolean isAdviceAnnotation(Annotation annotation) {
        try {
            Class interceptor = (Class)annotation.annotationType().getMethod("implementedBy", new Class[0]).invoke((Object)annotation, new Object[0]);
            return interceptor != null;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            return false;
        }
    }

    private Class<MethodInterceptor> extractAdviceClass(Annotation annotation, ClassLoader classloader) {
        try {
            Class interceptor = (Class)annotation.annotationType().getMethod("implementedBy", new Class[0]).invoke((Object)annotation, new Object[0]);
            return classloader.loadClass(interceptor.getName());
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            LOGGER.info("Annotations of type " + annotation.annotationType().getSimpleName() + " does not have an usable implementedBy field (references a class that implements MethodInterceptor)");
            return null;
        }
    }

    private <T> T callZeroArguementConstructor(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            return null;
        }
    }
}

