/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bbottema.javareflection.FieldWrapper;
import org.bbottema.javareflection.JReflect;
import org.bbottema.javareflection.commonslang25.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FieldUtils {
    @NotNull
    public static Map<Class<?>, List<FieldWrapper>> collectFields(Class<?> _class, Class<?> boundaryMarker, EnumSet<Visibility> visibility, EnumSet<BeanRestriction> beanRestrictions) {
        if (_class == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/FieldUtils.collectFields must not be null");
        }
        if (boundaryMarker == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/FieldUtils.collectFields must not be null");
        }
        if (visibility == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/FieldUtils.collectFields must not be null");
        }
        if (beanRestrictions == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/FieldUtils.collectFields must not be null");
        }
        HashMap fields = new HashMap();
        Field[] allFields = _class.getDeclaredFields();
        LinkedList<FieldWrapper> filteredFields = new LinkedList<FieldWrapper>();
        for (Field field : allFields) {
            FieldWrapper property;
            if (FieldUtils.meetsVisibilityRequirements(field, visibility) && (property = FieldUtils.resolveBeanProperty(field, beanRestrictions)) != null) {
                filteredFields.add(property);
            }
            fields.put(_class, filteredFields);
        }
        List<Class<?>> interfaces = Arrays.asList(_class.getInterfaces());
        if (_class.equals(boundaryMarker) || interfaces.contains(boundaryMarker)) {
            HashMap hashMap = fields;
            if (hashMap == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/FieldUtils.collectFields must not return null");
            }
            return hashMap;
        }
        fields.putAll(FieldUtils.collectFields(_class.getSuperclass(), boundaryMarker, visibility, beanRestrictions));
        HashMap hashMap = fields;
        if (hashMap == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/FieldUtils.collectFields must not return null");
        }
        return hashMap;
    }

    static boolean meetsVisibilityRequirements(Field field, EnumSet<Visibility> visibility) {
        if (field == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/FieldUtils.meetsVisibilityRequirements must not be null");
        }
        if (visibility == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/FieldUtils.meetsVisibilityRequirements must not be null");
        }
        for (Visibility visibilityModifier : visibility) {
            int m = field.getModifiers();
            if (!(!visibilityModifier.equals((Object)Visibility.DEFAULT) ? (m & visibilityModifier.modifierFlag) != 0 : !Modifier.isPrivate(m) && !Modifier.isProtected(m) && !Modifier.isPublic(m))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static FieldWrapper resolveBeanProperty(Field field, EnumSet<BeanRestriction> beanRestrictions) {
        if (field == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/FieldUtils.resolveBeanProperty must not be null");
        }
        if (beanRestrictions == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/FieldUtils.resolveBeanProperty must not be null");
        }
        if (beanRestrictions.containsAll(EnumSet.of(BeanRestriction.NO_GETTER, BeanRestriction.YES_GETTER)) || beanRestrictions.containsAll(EnumSet.of(BeanRestriction.NO_SETTER, BeanRestriction.YES_SETTER))) {
            throw new IllegalArgumentException("cannot both include and exclude a setter/getter requirement");
        }
        String setterName = "set" + StringUtils.capitalize(field.getName());
        String getterName = field.getType().equals(Boolean.TYPE) ? "is" + StringUtils.capitalize(field.getName()) : "get" + StringUtils.capitalize(field.getName());
        Method writeMethod = JReflect.findSimpleCompatibleMethod(field.getDeclaringClass(), setterName, field.getType());
        Method readMethod = JReflect.findSimpleCompatibleMethod(field.getDeclaringClass(), getterName, new Class[0]);
        if (!(readMethod != null && beanRestrictions.contains((Object)BeanRestriction.NO_GETTER) || readMethod == null && beanRestrictions.contains((Object)BeanRestriction.YES_GETTER) || writeMethod != null && beanRestrictions.contains((Object)BeanRestriction.NO_SETTER) || writeMethod == null && beanRestrictions.contains((Object)BeanRestriction.YES_SETTER))) {
            return new FieldWrapper(field, readMethod, writeMethod);
        }
        return null;
    }

    private FieldUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum BeanRestriction {
        YES_GETTER,
        YES_SETTER,
        NO_SETTER,
        NO_GETTER;


        private BeanRestriction() {
            if (string == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/FieldUtils$BeanRestriction.<init> must not be null");
            }
        }
    }

    public static enum Visibility {
        PRIVATE(2),
        DEFAULT(-1),
        PROTECTED(4),
        PUBLIC(1);

        private final int modifierFlag;

        private Visibility(int modifierFlag) {
            if (string == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/FieldUtils$Visibility.<init> must not be null");
            }
            this.modifierFlag = modifierFlag;
        }
    }
}

