/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bbottema.javareflection.ExternalClassLoader;
import org.bbottema.javareflection.valueconverter.ValueConversionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JReflect {
    private static final Map<Class<?>, Map<String, Map<AccessibleObject, Class<?>[]>>> methodCache = new LinkedHashMap();
    private static final Map<String, Class<?>> classCache = new HashMap();
    private static final Map<Class<?>, Integer> numSizes = new LinkedHashMap();

    public static void resetCaches() {
        classCache.clear();
        methodCache.clear();
    }

    @Nullable
    public static Class<?> locateClass(String className, boolean fullscan, @Nullable ExternalClassLoader classLoader) {
        if (className == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.locateClass must not be null");
        }
        String cacheKey = className + fullscan;
        if (classCache.containsKey(cacheKey)) {
            return classCache.get(cacheKey);
        }
        Class<?> _class = null;
        if (fullscan) {
            Package[] ps = Package.getPackages();
            for (int i = 0; i < ps.length && _class == null; ++i) {
                _class = JReflect.locateClass(ps[i].getName() + "." + className, classLoader);
            }
        } else {
            _class = JReflect.locateClass("java.lang." + className, classLoader);
        }
        classCache.put(cacheKey, _class);
        return _class;
    }

    @Nullable
    public static Class<?> locateClass(String fullClassName, @Nullable ExternalClassLoader classLoader) {
        if (fullClassName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.locateClass must not be null");
        }
        try {
            Class<?> _class = null;
            if (classLoader != null) {
                _class = classLoader.loadClass(fullClassName);
            }
            if (_class == null) {
                _class = Class.forName(fullClassName);
            }
            return _class;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @NotNull
    public static <T> T newInstanceSimple(Class<T> _class) {
        T t;
        if (_class == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.newInstanceSimple must not be null");
        }
        try {
            t = _class.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException("unable to invoke parameterless constructor; security problem", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("unable to complete instantiation of object", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("unable to access parameterless constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("unable to invoke parameterless constructor", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("unable to find parameterless constructor (not public?)", e);
        }
        if (t == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/JReflect.newInstanceSimple must not return null");
        }
        return t;
    }

    @Nullable
    public static <T> T invokeCompatibleMethod(@Nullable Object context, Class<?> datatype, String identifier, Object ... args) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/JReflect.invokeCompatibleMethod must not be null");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/JReflect.invokeCompatibleMethod must not be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/JReflect.invokeCompatibleMethod must not be null");
        }
        Class<?>[] signature = JReflect.collectTypes(args);
        EnumSet<LookupMode> lookupMode = EnumSet.of(LookupMode.AUTOBOX, LookupMode.CAST_TO_SUPER);
        try {
            method = JReflect.findCompatibleMethod(datatype, identifier, lookupMode, signature);
        }
        catch (NoSuchMethodException e1) {
            try {
                lookupMode.add(LookupMode.CAST_TO_INTERFACE);
                method = JReflect.findCompatibleMethod(datatype, identifier, lookupMode, signature);
            }
            catch (NoSuchMethodException e2) {
                lookupMode.add(LookupMode.COMMON_CONVERT);
                method = JReflect.findCompatibleMethod(datatype, identifier, lookupMode, signature);
            }
        }
        method.setAccessible(true);
        try {
            return (T)method.invoke(context, args);
        }
        catch (IllegalArgumentException e) {
            Object[] convertedArgs = ValueConversionHelper.convert(args, method.getParameterTypes(), true);
            return (T)method.invoke(context, convertedArgs);
        }
    }

    @NotNull
    public static <T> T invokeCompatibleConstructor(Class<T> datatype, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.invokeCompatibleConstructor must not be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/JReflect.invokeCompatibleConstructor must not be null");
        }
        Class<?>[] signature = JReflect.collectTypes(args);
        T t = JReflect.invokeConstructor(datatype, signature, args);
        if (t == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/JReflect.invokeCompatibleConstructor must not return null");
        }
        return t;
    }

    @NotNull
    public static <T> T invokeConstructor(Class<T> datatype, Class<?>[] signature, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        T t;
        Constructor<T> constructor;
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.invokeConstructor must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/JReflect.invokeConstructor must not be null");
        }
        if (args == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/JReflect.invokeConstructor must not be null");
        }
        EnumSet<LookupMode> lookupMode = EnumSet.of(LookupMode.AUTOBOX, LookupMode.CAST_TO_SUPER);
        try {
            constructor = JReflect.findCompatibleConstructor(datatype, lookupMode, signature);
        }
        catch (NoSuchMethodException e1) {
            try {
                lookupMode.add(LookupMode.CAST_TO_INTERFACE);
                constructor = JReflect.findCompatibleConstructor(datatype, lookupMode, signature);
            }
            catch (NoSuchMethodException e2) {
                lookupMode.add(LookupMode.COMMON_CONVERT);
                constructor = JReflect.findCompatibleConstructor(datatype, lookupMode, signature);
            }
        }
        try {
            t = constructor.newInstance(args);
        }
        catch (IllegalArgumentException e) {
            Object[] convertedArgs = ValueConversionHelper.convert(args, constructor.getParameterTypes(), true);
            T t2 = constructor.newInstance(convertedArgs);
            if (t2 == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/JReflect.invokeConstructor must not return null");
            }
            return t2;
        }
        if (t == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/JReflect.invokeConstructor must not return null");
        }
        return t;
    }

    @NotNull
    public static Class<?>[] collectTypes(Object[] objects) {
        if (objects == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.collectTypes must not be null");
        }
        Class[] types = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object o = objects[i];
            types[i] = o != null ? o.getClass() : Object.class;
        }
        if (types == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/JReflect.collectTypes must not return null");
        }
        return types;
    }

    @NotNull
    public static <T> Constructor<T> findCompatibleConstructor(Class<T> datatype, EnumSet<LookupMode> lookupMode, Class<?> ... types) throws NoSuchMethodException {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.findCompatibleConstructor must not be null");
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/JReflect.findCompatibleConstructor must not be null");
        }
        if (types == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/JReflect.findCompatibleConstructor must not be null");
        }
        Constructor<T> constructor = (Constructor<T>)JReflect.getMethodFromCache(datatype, datatype.getName(), types);
        if (constructor != null) {
            Constructor<T> constructor2 = constructor;
            if (constructor2 == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/JReflect.findCompatibleConstructor must not return null");
            }
            return constructor2;
        }
        try {
            constructor = datatype.getConstructor(types);
        }
        catch (NoSuchMethodException e) {
            List<Class<?>[]> typeslist = JReflect.generateCompatibleSignatures(lookupMode, types);
            for (Class<?>[] aTypeslist : typeslist) {
                try {
                    constructor = datatype.getConstructor(aTypeslist);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        if (constructor != null) {
            JReflect.addMethodToCache(datatype, datatype.getName(), constructor, types);
            Constructor<T> constructor3 = constructor;
            if (constructor3 == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/JReflect.findCompatibleConstructor must not return null");
            }
            return constructor3;
        }
        throw new NoSuchMethodException();
    }

    @Nullable
    public static Method findSimpleCompatibleMethod(Class<?> datatype, String methodName, Class<?> ... signature) {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.findSimpleCompatibleMethod must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/JReflect.findSimpleCompatibleMethod must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/JReflect.findSimpleCompatibleMethod must not be null");
        }
        try {
            return JReflect.findCompatibleMethod(datatype, methodName, EnumSet.noneOf(LookupMode.class), signature);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @NotNull
    public static Method findCompatibleMethod(Class<?> datatype, String methodName, EnumSet<LookupMode> lookupMode, Class<?> ... signature) throws NoSuchMethodException {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.findCompatibleMethod must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/JReflect.findCompatibleMethod must not be null");
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/JReflect.findCompatibleMethod must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/JReflect.findCompatibleMethod must not be null");
        }
        Method method = (Method)JReflect.getMethodFromCache(datatype, methodName, signature);
        if (method != null) {
            Method method2 = method;
            if (method2 == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/JReflect.findCompatibleMethod must not return null");
            }
            return method2;
        }
        try {
            method = JReflect.getMethod(datatype, methodName, signature);
        }
        catch (NoSuchMethodException e) {
            List<Class<?>[]> signatures = JReflect.generateCompatibleSignatures(lookupMode, signature);
            for (Class<?>[] compatibleSignature : signatures) {
                try {
                    method = JReflect.getMethod(datatype, methodName, compatibleSignature);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        if (method != null) {
            JReflect.addMethodToCache(datatype, methodName, method, signature);
            Method method3 = method;
            if (method3 == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/JReflect.findCompatibleMethod must not return null");
            }
            return method3;
        }
        throw new NoSuchMethodException();
    }

    @NotNull
    public static Method getMethod(Class<?> datatype, String name, Class<?> ... signature) throws NoSuchMethodException {
        Method method;
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.getMethod must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/JReflect.getMethod must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/JReflect.getMethod must not be null");
        }
        for (Class<?> iface : datatype.getInterfaces()) {
            Method method2;
            try {
                method2 = iface.getMethod(name, signature);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
            if (method2 == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/JReflect.getMethod must not return null");
            }
            return method2;
        }
        try {
            method = datatype.getMethod(name, signature);
        }
        catch (NoSuchMethodException e) {
            Method method3 = datatype.getDeclaredMethod(name, signature);
            if (method3 == null) {
                throw new IllegalStateException("NotNull method org/bbottema/javareflection/JReflect.getMethod must not return null");
            }
            return method3;
        }
        if (method == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/JReflect.getMethod must not return null");
        }
        return method;
    }

    public static boolean isMethodCompatible(Method method, EnumSet<LookupMode> lookupMode, Class<?> ... signature) {
        if (method == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.isMethodCompatible must not be null");
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/JReflect.isMethodCompatible must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/JReflect.isMethodCompatible must not be null");
        }
        Class<?>[] targetSignature = method.getParameterTypes();
        if (signature.length != targetSignature.length) {
            return false;
        }
        return JReflect.isSignatureCompatible(signature, targetSignature, lookupMode);
    }

    public static boolean isSignatureCompatible(Class<?>[] signature, Class<?>[] exactTargetSignature, EnumSet<LookupMode> lookupMode) {
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.isSignatureCompatible must not be null");
        }
        if (exactTargetSignature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/JReflect.isSignatureCompatible must not be null");
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/JReflect.isSignatureCompatible must not be null");
        }
        List<Class<?>[]> derivableSignatures = JReflect.generateCompatibleSignatures(lookupMode, signature);
        for (Class<?>[] derivableSignature : derivableSignatures) {
            boolean currentSignatureCompatible = true;
            for (int i = 0; i < derivableSignature.length && currentSignatureCompatible; ++i) {
                if (derivableSignature[i].equals(exactTargetSignature[i])) continue;
                currentSignatureCompatible = false;
            }
            if (!currentSignatureCompatible) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<Class<?>[]> generateCompatibleSignatures(EnumSet<LookupMode> lookupMode, Class<?> ... signature) {
        if (lookupMode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.generateCompatibleSignatures must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/JReflect.generateCompatibleSignatures must not be null");
        }
        ArrayList<Class<?>[]> signatures = new ArrayList<Class<?>[]>();
        JReflect.generateCompatibleSignatures(0, lookupMode, signatures, signature);
        ArrayList<Class<?>[]> arrayList = signatures;
        if (arrayList == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/JReflect.generateCompatibleSignatures must not return null");
        }
        return arrayList;
    }

    private static void generateCompatibleSignatures(int index, EnumSet<LookupMode> lookupMode, List<Class<?>[]> signatures, Class<?> ... signature) {
        if (lookupMode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/JReflect.generateCompatibleSignatures must not be null");
        }
        if (signatures == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/JReflect.generateCompatibleSignatures must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/JReflect.generateCompatibleSignatures must not be null");
        }
        if (index == signature.length) {
            signatures.add(signature);
        } else {
            Class[] newSignature;
            Class<?>[] autoboxed;
            Class<?> original = signature[index];
            JReflect.generateCompatibleSignatures(index + 1, lookupMode, signatures, (Class[])signature.clone());
            if (lookupMode.contains((Object)LookupMode.AUTOBOX) && (autoboxed = JReflect.autobox(original)) != null) {
                newSignature = (Class[])JReflect.replaceInArray((Object[])signature.clone(), index, autoboxed);
                JReflect.generateCompatibleSignatures(index + 1, lookupMode, signatures, newSignature);
            }
            if (lookupMode.contains((Object)LookupMode.CAST_TO_INTERFACE)) {
                for (Class<?> iface : original.getInterfaces()) {
                    Class<?>[] newSignature2 = JReflect.replaceInArray((Object[])signature.clone(), index, iface);
                    JReflect.generateCompatibleSignatures(index + 1, lookupMode, signatures, newSignature2);
                }
            }
            if (lookupMode.contains((Object)LookupMode.CAST_TO_SUPER)) {
                Class<?> supertype = original;
                while ((supertype = supertype.getSuperclass()) != null) {
                    newSignature = JReflect.replaceInArray((Object[])signature.clone(), index, supertype);
                    JReflect.generateCompatibleSignatures(index + 1, lookupMode, signatures, newSignature);
                }
            }
            if (lookupMode.contains((Object)LookupMode.COMMON_CONVERT)) {
                for (Class<?> convert : ValueConversionHelper.collectCompatibleTargetTypes(original)) {
                    Class<?>[] newSignature3 = JReflect.replaceInArray((Object[])signature.clone(), index, convert);
                    JReflect.generateCompatibleSignatures(index + 1, lookupMode, signatures, newSignature3);
                }
            }
        }
    }

    @Nullable
    public static Class<?> autobox(Class<?> c) {
        if (c == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.autobox must not be null");
        }
        if (c == Integer.class) {
            return Integer.TYPE;
        }
        if (c == Integer.TYPE) {
            return Integer.class;
        }
        if (c == Boolean.class) {
            return Boolean.TYPE;
        }
        if (c == Boolean.TYPE) {
            return Boolean.class;
        }
        if (c == Character.class) {
            return Character.TYPE;
        }
        if (c == Character.TYPE) {
            return Character.class;
        }
        if (c == Byte.class) {
            return Byte.TYPE;
        }
        if (c == Byte.TYPE) {
            return Byte.class;
        }
        if (c == Short.class) {
            return Short.TYPE;
        }
        if (c == Short.TYPE) {
            return Short.class;
        }
        if (c == Long.class) {
            return Long.TYPE;
        }
        if (c == Long.TYPE) {
            return Long.class;
        }
        if (c == Float.class) {
            return Float.TYPE;
        }
        if (c == Float.TYPE) {
            return Float.class;
        }
        if (c == Double.class) {
            return Double.TYPE;
        }
        if (c == Double.TYPE) {
            return Double.class;
        }
        return null;
    }

    @Nullable
    public static Field solveField(Object o, String fieldName) {
        if (o == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.solveField must not be null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/JReflect.solveField must not be null");
        }
        try {
            if (o.getClass().equals(Class.class)) {
                return ((Class)o).getField(fieldName);
            }
            return o.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    @Nullable
    private static <T> AccessibleObject getMethodFromCache(Class<T> datatype, String method, Class<?> ... signature) {
        Map<AccessibleObject, Class<?>[]> signatures;
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.getMethodFromCache must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/JReflect.getMethodFromCache must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/JReflect.getMethodFromCache must not be null");
        }
        Map<String, Map<AccessibleObject, Class<?>[]>> owner = methodCache.get(datatype);
        if (signature.length > 0 && owner != null && (signatures = owner.get(method)) != null) {
            for (Map.Entry<AccessibleObject, Class<?>[]> entry : signatures.entrySet()) {
                if (!Arrays.equals(entry.getValue(), signature)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private static void addMethodToCache(Class<?> datatype, String method, AccessibleObject methodRef, Class<?> ... signature) {
        if (datatype == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.addMethodToCache must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/JReflect.addMethodToCache must not be null");
        }
        if (methodRef == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/JReflect.addMethodToCache must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/JReflect.addMethodToCache must not be null");
        }
        if (signature.length > 0) {
            LinkedHashMap<String, Map> owner = methodCache.get(datatype);
            owner = owner != null ? owner : new LinkedHashMap<String, Map>();
            Map methods = (Map)owner.get(method);
            methods = methods != null ? methods : new LinkedHashMap();
            methods.put(methodRef, signature);
            methods.put(methodRef, signature);
            owner.put(method, methods);
            methodCache.put(datatype, owner);
        }
    }

    @Nullable
    public static Object assignToField(Object o, String property, Object value) throws IllegalAccessException, NoSuchFieldException {
        if (o == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.assignToField must not be null");
        }
        if (property == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/JReflect.assignToField must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/JReflect.assignToField must not be null");
        }
        Field field = JReflect.solveField(o, property);
        if (field != null) {
            Object assignedValue = value;
            try {
                field.set(o, value);
            }
            catch (IllegalArgumentException ie) {
                assignedValue = ValueConversionHelper.convert(value, field.getType());
                field.set(o, assignedValue);
            }
            return assignedValue;
        }
        throw new NoSuchFieldException();
    }

    public static boolean isPackage(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.isPackage must not be null");
        }
        return name.equals("java") || Package.getPackage(name) != null;
    }

    @NotNull
    public static Class<?> widestNumberClass(Number ... numbers) {
        if (numbers == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.widestNumberClass must not be null");
        }
        Integer widest = 0;
        Class widestNumberType = Byte.class;
        for (Number number : numbers) {
            Integer size = numSizes.get(number.getClass());
            if (size <= widest) continue;
            widestNumberType = number.getClass();
            widest = size;
        }
        Class<Byte> clazz = widestNumberType;
        if (clazz == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/JReflect.widestNumberClass must not return null");
        }
        return clazz;
    }

    @NotNull
    public static Collection<String> collectProperties(Object subject) {
        Field[] fields;
        if (subject == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.collectProperties must not be null");
        }
        LinkedHashSet<String> properties = new LinkedHashSet<String>();
        for (Field f : fields = subject.getClass().getFields()) {
            properties.add(f.getName());
        }
        LinkedHashSet<String> linkedHashSet = properties;
        if (linkedHashSet == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/JReflect.collectProperties must not return null");
        }
        return linkedHashSet;
    }

    @NotNull
    public static Set<String> collectMethods(Object subject, boolean publicOnly) {
        if (subject == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.collectMethods must not be null");
        }
        LinkedHashSet<String> methodNames = new LinkedHashSet<String>();
        HashSet<Method> allMethods = new HashSet<Method>(Arrays.asList(subject.getClass().getMethods()));
        if (!publicOnly) {
            for (Class<?> _class = subject.getClass(); _class != null; _class = _class.getSuperclass()) {
                allMethods.addAll(Arrays.asList(_class.getDeclaredMethods()));
            }
        }
        for (Method m : allMethods) {
            methodNames.add(m.getName());
        }
        LinkedHashSet<String> linkedHashSet = methodNames;
        if (linkedHashSet == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/JReflect.collectMethods must not return null");
        }
        return linkedHashSet;
    }

    @NotNull
    public static <T> T[] replaceInArray(T[] array, int index, T value) {
        if (array == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect.replaceInArray must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/JReflect.replaceInArray must not be null");
        }
        array[index] = value;
        if (array == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/JReflect.replaceInArray must not return null");
        }
        return array;
    }

    private JReflect() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        int size = 0;
        numSizes.put(Byte.class, ++size);
        numSizes.put(Short.class, ++size);
        numSizes.put(Integer.class, ++size);
        numSizes.put(Long.class, ++size);
        numSizes.put(Float.class, ++size);
        numSizes.put(Double.class, ++size);
    }

    public static enum LookupMode {
        AUTOBOX,
        CAST_TO_SUPER,
        CAST_TO_INTERFACE,
        COMMON_CONVERT;


        private LookupMode() {
            if (string == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/JReflect$LookupMode.<init> must not be null");
            }
        }
    }
}

