/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.bbottema.javareflection.util.ExternalClassLoader;
import org.bbottema.javareflection.valueconverter.ValueConversionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassUtils {
    private static final Map<String, Class<?>> classCache = new HashMap();

    public static void resetCache() {
        classCache.clear();
    }

    @Nullable
    public static Class<?> locateClass(String className, boolean fullscan, @Nullable ExternalClassLoader classLoader) {
        if (className == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.locateClass must not be null");
        }
        String cacheKey = className + fullscan;
        if (classCache.containsKey(cacheKey)) {
            return classCache.get(cacheKey);
        }
        Class<?> _class = null;
        if (fullscan) {
            Package[] ps = Package.getPackages();
            for (int i = 0; i < ps.length && _class == null; ++i) {
                _class = ClassUtils.locateClass(ps[i].getName() + "." + className, classLoader);
            }
        } else {
            _class = ClassUtils.locateClass("java.lang." + className, classLoader);
        }
        classCache.put(cacheKey, _class);
        return _class;
    }

    @Nullable
    public static Class<?> locateClass(String fullClassName, @Nullable ExternalClassLoader classLoader) {
        if (fullClassName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.locateClass must not be null");
        }
        try {
            Class<?> _class = null;
            if (classLoader != null) {
                _class = classLoader.loadClass(fullClassName);
            }
            if (_class == null) {
                _class = Class.forName(fullClassName);
            }
            return _class;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @NotNull
    public static <T> T newInstanceSimple(Class<T> _class) {
        T t;
        if (_class == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.newInstanceSimple must not be null");
        }
        try {
            t = _class.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException("unable to invoke parameterless constructor; security problem", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("unable to complete instantiation of object", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("unable to access parameterless constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("unable to invoke parameterless constructor", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("unable to find parameterless constructor (not public?)", e);
        }
        if (t == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/ClassUtils.newInstanceSimple must not return null");
        }
        return t;
    }

    @Nullable
    public static Field solveField(Object o, String fieldName) {
        if (o == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.solveField must not be null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ClassUtils.solveField must not be null");
        }
        try {
            if (o.getClass().equals(Class.class)) {
                return ((Class)o).getField(fieldName);
            }
            return o.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    @Nullable
    public static Object assignToField(Object o, String property, Object value) throws IllegalAccessException, NoSuchFieldException {
        if (o == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.assignToField must not be null");
        }
        if (property == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ClassUtils.assignToField must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/ClassUtils.assignToField must not be null");
        }
        Field field = ClassUtils.solveField(o, property);
        if (field != null) {
            Object assignedValue = value;
            try {
                field.set(o, value);
            }
            catch (IllegalArgumentException ie) {
                assignedValue = ValueConversionHelper.convert(value, field.getType());
                field.set(o, assignedValue);
            }
            return assignedValue;
        }
        throw new NoSuchFieldException();
    }

    @NotNull
    public static Collection<String> collectPropertyNames(Object subject) {
        Field[] fields;
        if (subject == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.collectPropertyNames must not be null");
        }
        LinkedHashSet<String> properties = new LinkedHashSet<String>();
        for (Field f : fields = subject.getClass().getFields()) {
            properties.add(f.getName());
        }
        LinkedHashSet<String> linkedHashSet = properties;
        if (linkedHashSet == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/ClassUtils.collectPropertyNames must not return null");
        }
        return linkedHashSet;
    }

    @NotNull
    public static Set<String> collectMethods(Object subject, boolean publicOnly) {
        if (subject == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.collectMethods must not be null");
        }
        LinkedHashSet<String> methodNames = new LinkedHashSet<String>();
        HashSet<Method> allMethods = new HashSet<Method>(Arrays.asList(subject.getClass().getMethods()));
        if (!publicOnly) {
            for (Class<?> _class = subject.getClass(); _class != null; _class = _class.getSuperclass()) {
                allMethods.addAll(Arrays.asList(_class.getDeclaredMethods()));
            }
        }
        for (Method m : allMethods) {
            methodNames.add(m.getName());
        }
        LinkedHashSet<String> linkedHashSet = methodNames;
        if (linkedHashSet == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/ClassUtils.collectMethods must not return null");
        }
        return linkedHashSet;
    }

    private ClassUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

