/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bbottema.javareflection.MethodUtils;
import org.bbottema.javareflection.model.FieldWrapper;
import org.bbottema.javareflection.model.InvokableObject;
import org.bbottema.javareflection.util.commonslang25.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BeanUtils {
    public static boolean isBeanMethod(Method method, Class<?> boundaryMarker, EnumSet<Visibility> visibility) {
        if (method == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/BeanUtils.isBeanMethod must not be null");
        }
        if (boundaryMarker == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/BeanUtils.isBeanMethod must not be null");
        }
        if (visibility == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/BeanUtils.isBeanMethod must not be null");
        }
        Map<Class<?>, List<FieldWrapper>> fields = BeanUtils.collectFields(method.getDeclaringClass(), boundaryMarker, visibility, EnumSet.noneOf(BeanRestriction.class));
        for (List<FieldWrapper> fieldWrappers : fields.values()) {
            for (FieldWrapper fieldWrapper : fieldWrappers) {
                if (!method.equals(fieldWrapper.getGetter()) && !method.equals(fieldWrapper.getSetter())) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static Map<Class<?>, List<FieldWrapper>> collectFields(Class<?> _class, Class<?> boundaryMarker, EnumSet<Visibility> visibility, EnumSet<BeanRestriction> beanRestrictions) {
        if (_class == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/BeanUtils.collectFields must not be null");
        }
        if (boundaryMarker == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/BeanUtils.collectFields must not be null");
        }
        if (visibility == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/BeanUtils.collectFields must not be null");
        }
        if (beanRestrictions == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/BeanUtils.collectFields must not be null");
        }
        HashMap fields = new HashMap();
        Field[] allFields = _class.getDeclaredFields();
        LinkedList<FieldWrapper> filteredFields = new LinkedList<FieldWrapper>();
        for (Field field : allFields) {
            FieldWrapper property;
            if (!BeanUtils.meetsVisibilityRequirements(field, visibility) || (property = BeanUtils.resolveBeanProperty(field, beanRestrictions)) == null) continue;
            filteredFields.add(property);
        }
        fields.put(_class, filteredFields);
        List<Class<?>> interfaces = Arrays.asList(_class.getInterfaces());
        if (!_class.equals(boundaryMarker) && !interfaces.contains(boundaryMarker)) {
            fields.putAll(BeanUtils.collectFields(_class.getSuperclass(), boundaryMarker, visibility, beanRestrictions));
        }
        HashMap hashMap = fields;
        if (hashMap == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/BeanUtils.collectFields must not return null");
        }
        return hashMap;
    }

    static boolean meetsVisibilityRequirements(Field field, EnumSet<Visibility> visibility) {
        if (field == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/BeanUtils.meetsVisibilityRequirements must not be null");
        }
        if (visibility == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/BeanUtils.meetsVisibilityRequirements must not be null");
        }
        int m = field.getModifiers();
        for (Visibility visibilityModifier : visibility) {
            if (!(visibilityModifier != Visibility.DEFAULT ? (m & visibilityModifier.modifierFlag) != 0 : !Modifier.isPrivate(m) && !Modifier.isProtected(m) && !Modifier.isPublic(m))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static FieldWrapper resolveBeanProperty(Field field, EnumSet<BeanRestriction> beanRestrictions) {
        if (field == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/BeanUtils.resolveBeanProperty must not be null");
        }
        if (beanRestrictions == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/BeanUtils.resolveBeanProperty must not be null");
        }
        if (beanRestrictions.containsAll(EnumSet.of(BeanRestriction.NO_GETTER, BeanRestriction.YES_GETTER)) || beanRestrictions.containsAll(EnumSet.of(BeanRestriction.NO_SETTER, BeanRestriction.YES_SETTER))) {
            throw new IllegalArgumentException("cannot both include and exclude a setter/getter requirement");
        }
        String setterName = "set" + StringUtils.capitalize(field.getName());
        String getterName = field.getType().equals(Boolean.TYPE) ? "is" + StringUtils.capitalize(field.getName()) : "get" + StringUtils.capitalize(field.getName());
        InvokableObject<Method> iWriteMethod = MethodUtils.findSimpleCompatibleMethod(field.getDeclaringClass(), setterName, field.getType());
        InvokableObject<Method> iReadMethod = MethodUtils.findSimpleCompatibleMethod(field.getDeclaringClass(), getterName, new Class[0]);
        if (!(iReadMethod != null && beanRestrictions.contains((Object)BeanRestriction.NO_GETTER) || iReadMethod == null && beanRestrictions.contains((Object)BeanRestriction.YES_GETTER) || iWriteMethod != null && beanRestrictions.contains((Object)BeanRestriction.NO_SETTER) || iWriteMethod == null && beanRestrictions.contains((Object)BeanRestriction.YES_SETTER))) {
            Method readMethod = iReadMethod != null ? iReadMethod.getMethod() : null;
            Method writeMethod = iWriteMethod != null ? iWriteMethod.getMethod() : null;
            return new FieldWrapper(field, readMethod, writeMethod);
        }
        return null;
    }

    private BeanUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum BeanRestriction {
        YES_GETTER,
        YES_SETTER,
        NO_SETTER,
        NO_GETTER;


        private BeanRestriction() {
            if (string == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/BeanUtils$BeanRestriction.<init> must not be null");
            }
        }
    }

    public static enum Visibility {
        PRIVATE(2),
        DEFAULT(-1),
        PROTECTED(4),
        PUBLIC(1);

        private final int modifierFlag;

        private Visibility(int modifierFlag) {
            if (string == null) {
                throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/BeanUtils$Visibility.<init> must not be null");
            }
            this.modifierFlag = modifierFlag;
        }
    }
}

