/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.bbottema.javareflection.PackageUtils;
import org.bbottema.javareflection.model.MethodModifier;
import org.bbottema.javareflection.valueconverter.ValueConversionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassUtils {
    private static final Map<String, Class<?>> classCache = new HashMap();

    public static void resetCache() {
        classCache.clear();
    }

    @Nullable
    public static Class<?> locateClass(String className, boolean fullscan, @Nullable ClassLoader classLoader) {
        if (className == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.locateClass must not be null");
        }
        String cacheKey = className + fullscan;
        if (classCache.containsKey(cacheKey)) {
            return classCache.get(cacheKey);
        }
        Class<?> _class = fullscan ? ClassUtils.locateClass(className, null, classLoader) : ClassUtils.locateClass(className, "java.lang", classLoader);
        classCache.put(cacheKey, _class);
        return _class;
    }

    @Nullable
    public static Class<?> locateClass(String className, @Nullable String inPackage, @Nullable ClassLoader classLoader) {
        if (className == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.locateClass must not be null");
        }
        String cacheKey = className + inPackage;
        if (classCache.containsKey(cacheKey)) {
            return classCache.get(cacheKey);
        }
        Class<?> _class = ClassUtils.locateClass(className, classLoader);
        if (_class == null) {
            _class = PackageUtils.scanPackagesForClass(className, inPackage, classLoader);
        }
        classCache.put(cacheKey, _class);
        return _class;
    }

    @Nullable
    public static Class<?> locateClass(String fullClassName, @Nullable ClassLoader classLoader) {
        if (fullClassName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.locateClass must not be null");
        }
        try {
            Class<?> _class = null;
            if (classLoader != null) {
                _class = classLoader.loadClass(fullClassName);
            }
            if (_class == null) {
                _class = Class.forName(fullClassName);
            }
            return _class;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @NotNull
    public static <T> T newInstanceSimple(Class<T> _class) {
        T t;
        if (_class == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.newInstanceSimple must not be null");
        }
        try {
            t = _class.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException("unable to invoke parameterless constructor; security problem", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("unable to complete instantiation of object", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("unable to access parameterless constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("unable to invoke parameterless constructor", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("unable to find parameterless constructor (not public?)", e);
        }
        if (t == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/ClassUtils.newInstanceSimple must not return null");
        }
        return t;
    }

    @Nullable
    public static Field solveField(Object o, String fieldName) {
        if (o == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.solveField must not be null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ClassUtils.solveField must not be null");
        }
        try {
            if (o.getClass().equals(Class.class)) {
                return ((Class)o).getField(fieldName);
            }
            return o.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    @Nullable
    public static Object assignToField(Object o, String property, Object value) throws IllegalAccessException, NoSuchFieldException {
        if (o == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.assignToField must not be null");
        }
        if (property == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ClassUtils.assignToField must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/ClassUtils.assignToField must not be null");
        }
        Field field = ClassUtils.solveField(o, property);
        if (field != null) {
            Object assignedValue = value;
            try {
                field.set(o, value);
            }
            catch (IllegalArgumentException ie) {
                assignedValue = ValueConversionHelper.convert(value, field.getType());
                field.set(o, assignedValue);
            }
            return assignedValue;
        }
        throw new NoSuchFieldException();
    }

    @NotNull
    public static Collection<String> collectPropertyNames(Object subject) {
        Field[] fields;
        if (subject == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.collectPropertyNames must not be null");
        }
        LinkedHashSet<String> properties = new LinkedHashSet<String>();
        for (Field f : fields = subject.getClass().getFields()) {
            properties.add(f.getName());
        }
        LinkedHashSet<String> linkedHashSet = properties;
        if (linkedHashSet == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/ClassUtils.collectPropertyNames must not return null");
        }
        return linkedHashSet;
    }

    public static Set<String> collectMethodNames(Class<?> dataType, Class<?> boundaryMarker, EnumSet<MethodModifier> methodModifiers) {
        if (dataType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.collectMethodNames must not be null");
        }
        if (boundaryMarker == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ClassUtils.collectMethodNames must not be null");
        }
        if (methodModifiers == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/ClassUtils.collectMethodNames must not be null");
        }
        HashSet<String> methodNames = new HashSet<String>();
        for (Method m : ClassUtils.collectMethods(dataType, boundaryMarker, methodModifiers)) {
            methodNames.add(m.getName());
        }
        HashSet<String> hashSet = methodNames;
        if (hashSet == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/ClassUtils.collectMethodNames must not return null");
        }
        return hashSet;
    }

    public static Set<Method> collectMethodsByName(Class<?> type, Class<?> boundaryMarker, EnumSet<MethodModifier> methodModifiers, String methodName) {
        if (type == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.collectMethodsByName must not be null");
        }
        if (boundaryMarker == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ClassUtils.collectMethodsByName must not be null");
        }
        if (methodModifiers == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/ClassUtils.collectMethodsByName must not be null");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/ClassUtils.collectMethodsByName must not be null");
        }
        Set<Method> set = ClassUtils.collectMethodsMappingToName(type, boundaryMarker, methodModifiers).get(methodName);
        if (set == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/ClassUtils.collectMethodsByName must not return null");
        }
        return set;
    }

    public static Map<String, Set<Method>> collectMethodsMappingToName(Class<?> type, Class<?> boundaryMarker, EnumSet<MethodModifier> methodModifiers) {
        if (type == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.collectMethodsMappingToName must not be null");
        }
        if (boundaryMarker == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ClassUtils.collectMethodsMappingToName must not be null");
        }
        if (methodModifiers == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/ClassUtils.collectMethodsMappingToName must not be null");
        }
        HashMap<String, Set<Method>> methodsMappedToName = new HashMap<String, Set<Method>>();
        for (Method method : ClassUtils.collectMethods(type, boundaryMarker, methodModifiers)) {
            if (!methodsMappedToName.containsKey(method.getName())) {
                methodsMappedToName.put(method.getName(), new HashSet());
            }
            ((Set)methodsMappedToName.get(method.getName())).add(method);
        }
        HashMap<String, Set<Method>> hashMap = methodsMappedToName;
        if (hashMap == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/ClassUtils.collectMethodsMappingToName must not return null");
        }
        return hashMap;
    }

    public static Set<Method> collectMethods(Class<?> dataType, Class<?> boundaryMarker, EnumSet<MethodModifier> methodModifiers) {
        if (dataType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/ClassUtils.collectMethods must not be null");
        }
        if (boundaryMarker == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/ClassUtils.collectMethods must not be null");
        }
        if (methodModifiers == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/ClassUtils.collectMethods must not be null");
        }
        HashSet<Method> allMethods = new HashSet<Method>();
        for (Method declaredMethod : dataType.getDeclaredMethods()) {
            if (!MethodModifier.meetsModifierRequirements(declaredMethod, methodModifiers)) continue;
            allMethods.add(declaredMethod);
        }
        if (dataType != boundaryMarker && dataType.getSuperclass() != null) {
            allMethods.addAll(ClassUtils.collectMethods(dataType.getSuperclass(), boundaryMarker, methodModifiers));
        }
        HashSet<Method> hashSet = allMethods;
        if (hashSet == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/ClassUtils.collectMethods must not return null");
        }
        return hashSet;
    }

    private ClassUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

