/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bbottema.javareflection.model.InvokableObject;
import org.bbottema.javareflection.model.LookupMode;
import org.bbottema.javareflection.util.ArrayKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupCaches {
    static final Map<String, Class<?>> CLASS_CACHE = new HashMap();
    static final Map<Class<?>, Map<String, Map<Class<?>[], Set<InvokableObject>>>> METHOD_CACHE = new LinkedHashMap();
    static final Map<Class<?>, Set<Class<?>>> CACHED_REGISTERED_COMPATIBLE_TARGET_TYPES = new HashMap();
    static final Map<Class<?>, Set<Class<?>>> CACHED_COMPATIBLE_TARGET_TYPES = new HashMap();
    static final Map<EnumSet<LookupMode>, Map<ArrayKey, List<Class<?>[]>>> CACHED_COMPATIBLE_TYPE_LISTS = new HashMap<EnumSet<LookupMode>, Map<ArrayKey, List<Class<?>[]>>>();

    public static void resetCache() {
        CLASS_CACHE.clear();
        METHOD_CACHE.clear();
        CACHED_REGISTERED_COMPATIBLE_TARGET_TYPES.clear();
        CACHED_COMPATIBLE_TARGET_TYPES.clear();
        CACHED_COMPATIBLE_TYPE_LISTS.clear();
    }

    @Nullable
    static List<Class<?>[]> getCachedCompatibleSignatures(EnumSet<LookupMode> lookupMode, ArrayKey arrayKey) {
        List<Class<?>[]> cachedResult;
        if (lookupMode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/LookupCaches.getCachedCompatibleSignatures must not be null");
        }
        if (arrayKey == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/LookupCaches.getCachedCompatibleSignatures must not be null");
        }
        Map<ArrayKey, List<Class<?>[]>> cachedCompatibleSignatures = CACHED_COMPATIBLE_TYPE_LISTS.get(lookupMode);
        if (cachedCompatibleSignatures != null && (cachedResult = cachedCompatibleSignatures.get(arrayKey)) != null) {
            return cachedResult;
        }
        return null;
    }

    @NotNull
    static List<Class<?>[]> addCompatiblesignaturesToCache(EnumSet<LookupMode> lookupMode, ArrayKey arrayKey, List<Class<?>[]> compatibleTypeLists) {
        if (lookupMode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/LookupCaches.addCompatiblesignaturesToCache must not be null");
        }
        if (arrayKey == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/LookupCaches.addCompatiblesignaturesToCache must not be null");
        }
        if (compatibleTypeLists == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/LookupCaches.addCompatiblesignaturesToCache must not be null");
        }
        Map<ArrayKey, List<Class<?>[]>> cachedCompatibleSignatures = CACHED_COMPATIBLE_TYPE_LISTS.get(lookupMode);
        if (cachedCompatibleSignatures == null) {
            cachedCompatibleSignatures = new HashMap<ArrayKey, List<Class<?>[]>>();
            CACHED_COMPATIBLE_TYPE_LISTS.put(lookupMode, cachedCompatibleSignatures);
        }
        cachedCompatibleSignatures.put(arrayKey, compatibleTypeLists);
        List<Class<?>[]> list = compatibleTypeLists;
        if (list == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/LookupCaches.addCompatiblesignaturesToCache must not return null");
        }
        return list;
    }
}

