/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bbottema.javareflection.LookupCaches;
import org.bbottema.javareflection.model.LookupMode;
import org.bbottema.javareflection.util.ArrayKey;
import org.bbottema.javareflection.valueconverter.ValueConversionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeUtils {
    private static final Map<Class<?>, Integer> numSizes = new LinkedHashMap();

    @NotNull
    public static Class<?>[] collectTypes(Object[] objects) {
        if (objects == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/TypeUtils.collectTypes must not be null");
        }
        Class[] types = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object o = objects[i];
            types[i] = o != null ? o.getClass() : Object.class;
        }
        if (types == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/TypeUtils.collectTypes must not return null");
        }
        return types;
    }

    public static boolean isTypeListCompatible(Class<?>[] inputTypeList, Class<?>[] targetTypeList, Set<LookupMode> lookupMode) {
        if (inputTypeList == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/TypeUtils.isTypeListCompatible must not be null");
        }
        if (targetTypeList == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/TypeUtils.isTypeListCompatible must not be null");
        }
        if (lookupMode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/TypeUtils.isTypeListCompatible must not be null");
        }
        List<Class<?>[]> derivableTypeLists = TypeUtils.generateCompatibleTypeLists(lookupMode, inputTypeList);
        for (Class<?>[] derivableTypeList : derivableTypeLists) {
            boolean currentTypeListCompatible = true;
            for (int i = 0; i < derivableTypeList.length && currentTypeListCompatible; ++i) {
                if (derivableTypeList[i].equals(targetTypeList[i])) continue;
                currentTypeListCompatible = false;
            }
            if (!currentTypeListCompatible) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<Class<?>[]> generateCompatibleTypeLists(Set<LookupMode> lookupMode, Class<?> ... inputTypelist) {
        if (lookupMode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/TypeUtils.generateCompatibleTypeLists must not be null");
        }
        if (inputTypelist == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/TypeUtils.generateCompatibleTypeLists must not be null");
        }
        ArrayKey arrayKey = new ArrayKey(inputTypelist);
        List<Class<?>[]> cachedResult = LookupCaches.getCachedCompatibleSignatures(lookupMode, arrayKey);
        List<Class<?>[]> list = cachedResult != null ? cachedResult : LookupCaches.addCompatiblesignaturesToCache(lookupMode, arrayKey, TypeUtils.generateCompatibleTypeLists(0, lookupMode, new ArrayList<Class<?>[]>(), inputTypelist));
        if (list == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/TypeUtils.generateCompatibleTypeLists must not return null");
        }
        return list;
    }

    private static List<Class<?>[]> generateCompatibleTypeLists(int index, Set<LookupMode> lookupMode, List<Class<?>[]> compatibleTypeLists, Class<?> ... inputTypelist) {
        if (lookupMode == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/TypeUtils.generateCompatibleTypeLists must not be null");
        }
        if (compatibleTypeLists == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/TypeUtils.generateCompatibleTypeLists must not be null");
        }
        if (inputTypelist == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 3 of org/bbottema/javareflection/TypeUtils.generateCompatibleTypeLists must not be null");
        }
        if (index == inputTypelist.length) {
            compatibleTypeLists.add(inputTypelist);
        } else {
            Class[] newTypeList;
            Class<?>[] autoboxed;
            Class<?> original = inputTypelist[index];
            TypeUtils.generateCompatibleTypeLists(index + 1, lookupMode, compatibleTypeLists, (Class[])inputTypelist.clone());
            if (lookupMode.contains((Object)LookupMode.AUTOBOX) && !lookupMode.contains((Object)LookupMode.SMART_CONVERT) && (autoboxed = TypeUtils.autobox(original)) != null) {
                newTypeList = (Class[])TypeUtils.replaceInArray((Object[])inputTypelist.clone(), index, autoboxed);
                TypeUtils.generateCompatibleTypeLists(index + 1, lookupMode, compatibleTypeLists, newTypeList);
            }
            if (lookupMode.contains((Object)LookupMode.CAST_TO_INTERFACE)) {
                for (Class<?> iface : original.getInterfaces()) {
                    Class<?>[] newTypeList2 = TypeUtils.replaceInArray((Object[])inputTypelist.clone(), index, iface);
                    TypeUtils.generateCompatibleTypeLists(index + 1, lookupMode, compatibleTypeLists, newTypeList2);
                }
            }
            if (lookupMode.contains((Object)LookupMode.CAST_TO_SUPER)) {
                Class<?> supertype = original;
                while ((supertype = supertype.getSuperclass()) != null) {
                    newTypeList = TypeUtils.replaceInArray((Object[])inputTypelist.clone(), index, supertype);
                    TypeUtils.generateCompatibleTypeLists(index + 1, lookupMode, compatibleTypeLists, newTypeList);
                }
            }
            if (lookupMode.contains((Object)LookupMode.COMMON_CONVERT) && !lookupMode.contains((Object)LookupMode.SMART_CONVERT)) {
                for (Class<?> convert : TypeUtils.collectRegisteredCompatibleTargetTypes(original)) {
                    Class<?>[] newTypeList3 = TypeUtils.replaceInArray((Object[])inputTypelist.clone(), index, convert);
                    TypeUtils.generateCompatibleTypeLists(index + 1, lookupMode, compatibleTypeLists, newTypeList3);
                }
            }
            if (lookupMode.contains((Object)LookupMode.SMART_CONVERT)) {
                for (Class<?> convert : TypeUtils.collectCompatibleTargetTypes(original)) {
                    Class<?>[] newTypeList4 = TypeUtils.replaceInArray((Object[])inputTypelist.clone(), index, convert);
                    TypeUtils.generateCompatibleTypeLists(index + 1, lookupMode, compatibleTypeLists, newTypeList4);
                }
            }
        }
        List<Class<?>[]> list = compatibleTypeLists;
        if (list == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/TypeUtils.generateCompatibleTypeLists must not return null");
        }
        return list;
    }

    @NotNull
    private static Set<Class<?>> collectRegisteredCompatibleTargetTypes(Class<?> fromType) {
        if (fromType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/TypeUtils.collectRegisteredCompatibleTargetTypes must not be null");
        }
        if (!LookupCaches.CACHED_REGISTERED_COMPATIBLE_TARGET_TYPES.containsKey(fromType)) {
            LookupCaches.CACHED_REGISTERED_COMPATIBLE_TARGET_TYPES.put(fromType, ValueConversionHelper.collectRegisteredCompatibleTargetTypes(fromType));
        }
        Set<Class<?>> set = LookupCaches.CACHED_REGISTERED_COMPATIBLE_TARGET_TYPES.get(fromType);
        if (set == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/TypeUtils.collectRegisteredCompatibleTargetTypes must not return null");
        }
        return set;
    }

    @NotNull
    private static Set<Class<?>> collectCompatibleTargetTypes(Class<?> fromType) {
        if (fromType == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/TypeUtils.collectCompatibleTargetTypes must not be null");
        }
        if (!LookupCaches.CACHED_COMPATIBLE_TARGET_TYPES.containsKey(fromType)) {
            LookupCaches.CACHED_COMPATIBLE_TARGET_TYPES.put(fromType, ValueConversionHelper.collectCompatibleTargetTypes(fromType));
        }
        Set<Class<?>> set = LookupCaches.CACHED_COMPATIBLE_TARGET_TYPES.get(fromType);
        if (set == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/TypeUtils.collectCompatibleTargetTypes must not return null");
        }
        return set;
    }

    @Nullable
    public static Class<?> autobox(Class<?> c) {
        if (c == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/TypeUtils.autobox must not be null");
        }
        if (c == Integer.class) {
            return Integer.TYPE;
        }
        if (c == Integer.TYPE) {
            return Integer.class;
        }
        if (c == Boolean.class) {
            return Boolean.TYPE;
        }
        if (c == Boolean.TYPE) {
            return Boolean.class;
        }
        if (c == Character.class) {
            return Character.TYPE;
        }
        if (c == Character.TYPE) {
            return Character.class;
        }
        if (c == Byte.class) {
            return Byte.TYPE;
        }
        if (c == Byte.TYPE) {
            return Byte.class;
        }
        if (c == Short.class) {
            return Short.TYPE;
        }
        if (c == Short.TYPE) {
            return Short.class;
        }
        if (c == Long.class) {
            return Long.TYPE;
        }
        if (c == Long.TYPE) {
            return Long.class;
        }
        if (c == Float.class) {
            return Float.TYPE;
        }
        if (c == Float.TYPE) {
            return Float.class;
        }
        if (c == Double.class) {
            return Double.TYPE;
        }
        if (c == Double.TYPE) {
            return Double.class;
        }
        return null;
    }

    @NotNull
    public static Class<?> widestNumberClass(Number ... numbers) {
        if (numbers == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/TypeUtils.widestNumberClass must not be null");
        }
        Integer widest = 0;
        Class widestNumberType = Byte.class;
        for (Number number : numbers) {
            Integer size = numSizes.get(number.getClass());
            if (size <= widest) continue;
            widestNumberType = number.getClass();
            widest = size;
        }
        Class<Byte> clazz = widestNumberType;
        if (clazz == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/TypeUtils.widestNumberClass must not return null");
        }
        return clazz;
    }

    public static boolean isPackage(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/TypeUtils.isPackage must not be null");
        }
        return name.equals("java") || Package.getPackage(name) != null;
    }

    public static boolean containsAnnotation(List<Annotation> myListOfAnnotations, Class<? extends Annotation> annotationClass) {
        if (myListOfAnnotations == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/TypeUtils.containsAnnotation must not be null");
        }
        if (annotationClass == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/TypeUtils.containsAnnotation must not be null");
        }
        return TypeUtils.findAnnotation(myListOfAnnotations, annotationClass) != null;
    }

    public static boolean containsAnnotation(Annotation[] myListOfAnnotations, Class<? extends Annotation> annotationClass) {
        if (myListOfAnnotations == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/TypeUtils.containsAnnotation must not be null");
        }
        if (annotationClass == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/TypeUtils.containsAnnotation must not be null");
        }
        return TypeUtils.findAnnotation(myListOfAnnotations, annotationClass) != null;
    }

    @Nullable
    public static <T extends Annotation> T findAnnotation(Collection<Annotation> myListOfAnnotations, Class<T> annotationClass) {
        if (myListOfAnnotations == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/TypeUtils.findAnnotation must not be null");
        }
        if (annotationClass == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/TypeUtils.findAnnotation must not be null");
        }
        return TypeUtils.findAnnotation(myListOfAnnotations.toArray(new Annotation[0]), annotationClass);
    }

    @Nullable
    public static <T extends Annotation> T findAnnotation(Annotation[] myListOfAnnotations, Class<T> annotationClass) {
        if (myListOfAnnotations == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/TypeUtils.findAnnotation must not be null");
        }
        if (annotationClass == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 1 of org/bbottema/javareflection/TypeUtils.findAnnotation must not be null");
        }
        for (Annotation annotation : myListOfAnnotations) {
            if (annotation.annotationType() != annotationClass) continue;
            return (T)annotation;
        }
        return null;
    }

    @NotNull
    static <T> T[] replaceInArray(T[] array, int index, T value) {
        if (array == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 0 of org/bbottema/javareflection/TypeUtils.replaceInArray must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Implicit NotNull argument 2 of org/bbottema/javareflection/TypeUtils.replaceInArray must not be null");
        }
        array[index] = value;
        if (array == null) {
            throw new IllegalStateException("NotNull method org/bbottema/javareflection/TypeUtils.replaceInArray must not return null");
        }
        return array;
    }

    private TypeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        int size = 0;
        numSizes.put(Byte.class, ++size);
        numSizes.put(Short.class, ++size);
        numSizes.put(Integer.class, ++size);
        numSizes.put(Long.class, ++size);
        numSizes.put(Float.class, ++size);
        numSizes.put(Double.class, ++size);
    }
}

