/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javareflection.valueconverter.converters;

import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import org.bbottema.javareflection.util.Function;
import org.bbottema.javareflection.valueconverter.ValueFunction;
import org.jetbrains.annotations.Nullable;

@Nullable
public final class FileConverters {
    public static final Collection<ValueFunction<File, ?>> FILE_CONVERTERS = FileConverters.produceFileConverters();

    private static Collection<ValueFunction<File, ?>> produceFileConverters() {
        ArrayList converters = new ArrayList();
        converters.add(new ValueFunction.ValueFunctionImpl<File, File>(File.class, File.class, Function.Functions.identity()));
        converters.add(new ValueFunction.ValueFunctionImpl<File, DataSource>(File.class, DataSource.class, new FileToDataSourceFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<File, byte[]>(File.class, byte[].class, new FileToByteArrayFunction()));
        converters.add(new ValueFunction.ValueFunctionImpl<File, InputStream>(File.class, InputStream.class, new FileToInputStreamFunction()));
        return converters;
    }

    private FileConverters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class FileToInputStreamFunction
    implements Function<File, InputStream> {
        private FileToInputStreamFunction() {
        }

        @Override
        public InputStream apply(File file) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new AssertionError("File found, but also not found? Is this the real life...", e);
            }
        }
    }

    private static class FileToByteArrayFunction
    implements Function<File, byte[]> {
        private FileToByteArrayFunction() {
        }

        @Override
        public byte[] apply(File file) {
            try {
                return Files.readAllBytes(file.toPath());
            }
            catch (IOException e) {
                throw new RuntimeException("Was unable to read file content", e);
            }
        }
    }

    private static class FileToDataSourceFunction
    implements Function<File, DataSource> {
        private FileToDataSourceFunction() {
        }

        @Override
        public DataSource apply(File file) {
            return new FileDataSource(file);
        }
    }
}

