/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import me.chanjar.weixin.common.annotation.Required;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;

public class BeanUtils {
    public static void checkRequiredFields(Object bean) throws WxErrorException {
        ArrayList nullFields = Lists.newArrayList();
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(bean.getClass().getDeclaredFields()));
        fields.addAll(Arrays.asList(bean.getClass().getSuperclass().getDeclaredFields()));
        for (Field field : fields) {
            try {
                boolean isAccessible = field.isAccessible();
                field.setAccessible(true);
                if (field.isAnnotationPresent(Required.class) && field.get(bean) == null) {
                    nullFields.add(field.getName());
                }
                field.setAccessible(isAccessible);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                e.printStackTrace();
            }
        }
        if (!nullFields.isEmpty()) {
            throw new WxErrorException(WxError.newBuilder().setErrorMsg("\u5fc5\u586b\u5b57\u6bb5 " + nullFields + " \u5fc5\u987b\u63d0\u4f9b\u503c").build());
        }
    }

    public static Map<String, String> xmlBean2Map(Object bean) {
        HashMap result = Maps.newHashMap();
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(bean.getClass().getDeclaredFields()));
        fields.addAll(Arrays.asList(bean.getClass().getSuperclass().getDeclaredFields()));
        for (Field field : fields) {
            try {
                boolean isAccessible = field.isAccessible();
                field.setAccessible(true);
                if (field.get(bean) == null) {
                    field.setAccessible(isAccessible);
                    continue;
                }
                if (field.isAnnotationPresent(XStreamAlias.class)) {
                    result.put(field.getAnnotation(XStreamAlias.class).value(), field.get(bean).toString());
                }
                field.setAccessible(isAccessible);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

