/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.taskmaster.servlet.combo;

import com.github.bordertech.taskmaster.servlet.combo.AbstractComboServletListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

public class AbstractComboServletListenerTest {
    @Rule
    public MockitoRule initRule = MockitoJUnit.rule();

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor1NullListener() {
        new AbstractComboServletListener(null, new ServletContextListener[0]){};
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor1NullArrayEntry() {
        ServletContextListener testListener = (ServletContextListener)Mockito.mock(ServletContextListener.class);
        new AbstractComboServletListener(testListener, new ServletContextListener[]{null}){};
    }

    @Test
    public void testConstructor1SingleListener() {
        ServletContextListener testListener = (ServletContextListener)Mockito.mock(ServletContextListener.class);
        AbstractComboServletListener listener = new AbstractComboServletListener(testListener, new ServletContextListener[0]){};
        Assert.assertEquals((String)"Backing listeners should contain one entry", (long)1L, (long)listener.getListeners().size());
        Assert.assertSame((String)"Backing listeners should contain single listener", (Object)testListener, listener.getListeners().get(0));
    }

    @Test
    public void testConstructor1MultiListeners() {
        ServletContextListener testListener1 = (ServletContextListener)Mockito.mock(ServletContextListener.class);
        ServletContextListener testListener2 = (ServletContextListener)Mockito.mock(ServletContextListener.class);
        ServletContextListener testListener3 = (ServletContextListener)Mockito.mock(ServletContextListener.class);
        AbstractComboServletListener listener = new AbstractComboServletListener(testListener1, new ServletContextListener[]{testListener2, testListener3}){};
        Assert.assertEquals((String)"Backing listeners should contain three entries", (long)3L, (long)listener.getListeners().size());
        Assert.assertSame((String)"Backing listeners should contain first listener", (Object)testListener1, listener.getListeners().get(0));
        Assert.assertSame((String)"Backing listeners should contain second listener", (Object)testListener2, listener.getListeners().get(1));
        Assert.assertSame((String)"Backing listeners should contain third listener", (Object)testListener3, listener.getListeners().get(2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor2NullList() {
        new AbstractComboServletListener(null){};
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor2EmptyList() {
        new AbstractComboServletListener(new ArrayList()){};
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructor2NullEntry() {
        new AbstractComboServletListener(Arrays.asList(new ServletContextListener[]{null})){};
    }

    @Test
    public void testConstructor2MultiListeners() {
        ServletContextListener testListener1 = (ServletContextListener)Mockito.mock(ServletContextListener.class);
        ServletContextListener testListener2 = (ServletContextListener)Mockito.mock(ServletContextListener.class);
        ServletContextListener testListener3 = (ServletContextListener)Mockito.mock(ServletContextListener.class);
        List<ServletContextListener> testListeners = Arrays.asList(testListener1, testListener2, testListener3);
        AbstractComboServletListener listener = new AbstractComboServletListener(testListeners){};
        Assert.assertEquals((String)"Backing listeners should match test listeners", testListeners, (Object)listener.getListeners());
    }

    @Test
    public void testInitListener() throws ServletException {
        ServletContextEvent sce = (ServletContextEvent)Mockito.mock(ServletContextEvent.class);
        ServletContextListener testListener1 = (ServletContextListener)Mockito.mock(ServletContextListener.class);
        ServletContextListener testListener2 = (ServletContextListener)Mockito.mock(ServletContextListener.class);
        AbstractComboServletListener listener = new AbstractComboServletListener(testListener1, new ServletContextListener[]{testListener2}){};
        listener.contextInitialized(sce);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{testListener1, testListener2});
        ((ServletContextListener)inOrder.verify((Object)testListener1)).contextInitialized(sce);
        ((ServletContextListener)inOrder.verify((Object)testListener2)).contextInitialized(sce);
    }

    @Test
    public void testDestroyListener() {
        ServletContextEvent sce = (ServletContextEvent)Mockito.mock(ServletContextEvent.class);
        ServletContextListener testListener1 = (ServletContextListener)Mockito.mock(ServletContextListener.class);
        ServletContextListener testListener2 = (ServletContextListener)Mockito.mock(ServletContextListener.class);
        AbstractComboServletListener listener = new AbstractComboServletListener(testListener1, new ServletContextListener[]{testListener2}){};
        listener.contextDestroyed(sce);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{testListener1, testListener2});
        ((ServletContextListener)inOrder.verify((Object)testListener1)).contextDestroyed(sce);
        ((ServletContextListener)inOrder.verify((Object)testListener2)).contextDestroyed(sce);
    }

    @Test
    public void testInitException() throws ServletException {
        ServletContextEvent sce = (ServletContextEvent)Mockito.mock(ServletContextEvent.class);
        ServletContextListener testListener1 = (ServletContextListener)Mockito.mock(ServletContextListener.class);
        ServletContextListener testListener2 = (ServletContextListener)Mockito.mock(ServletContextListener.class);
        ((ServletContextListener)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException()}).when((Object)testListener1)).contextInitialized(sce);
        AbstractComboServletListener listener = new AbstractComboServletListener(testListener1, new ServletContextListener[]{testListener2}){};
        listener.contextInitialized(sce);
        ((ServletContextListener)Mockito.verify((Object)testListener2)).contextInitialized(sce);
    }

    @Test
    public void testDestoryException() throws ServletException {
        ServletContextEvent sce = (ServletContextEvent)Mockito.mock(ServletContextEvent.class);
        ServletContextListener testListener1 = (ServletContextListener)Mockito.mock(ServletContextListener.class);
        ServletContextListener testListener2 = (ServletContextListener)Mockito.mock(ServletContextListener.class);
        ((ServletContextListener)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalStateException()}).when((Object)testListener1)).contextDestroyed(sce);
        AbstractComboServletListener listener = new AbstractComboServletListener(testListener1, new ServletContextListener[]{testListener2}){};
        listener.contextDestroyed(sce);
        ((ServletContextListener)Mockito.verify((Object)testListener2)).contextDestroyed(sce);
    }
}

