/*
 * Decompiled with CFR 0.152.
 */
package com.github.bordertech.taskmaster.servlet.combo;

import com.github.bordertech.taskmaster.servlet.combo.ComboFilterChain;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public abstract class AbstractComboFilter
implements Filter {
    private final List<Filter> filters;

    protected AbstractComboFilter(Filter filter, Filter ... filters) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        boolean hasNull = Arrays.stream(filters).anyMatch(Objects::isNull);
        if (hasNull) {
            throw new IllegalArgumentException("Filters cannot contain a null filter");
        }
        ArrayList<Filter> backing = new ArrayList<Filter>();
        backing.add(filter);
        backing.addAll(Arrays.asList(filters));
        this.filters = Collections.unmodifiableList(backing);
    }

    protected AbstractComboFilter(List<Filter> filters) {
        if (filters == null || filters.isEmpty()) {
            throw new IllegalArgumentException("List of filters cannot be null or empty");
        }
        boolean hasNull = filters.stream().anyMatch(Objects::isNull);
        if (hasNull) {
            throw new IllegalArgumentException("Filters list cannot contain a null filter");
        }
        this.filters = Collections.unmodifiableList(filters);
    }

    public final List<Filter> getFilters() {
        return this.filters;
    }

    public void init(FilterConfig config) throws ServletException {
        for (Filter filter : this.getFilters()) {
            filter.init(config);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ComboFilterChain combo = new ComboFilterChain(chain, this.getFilters());
        combo.doFilter(request, response);
    }

    public void destroy() {
        int i = this.getFilters().size();
        while (i-- > 0) {
            Filter filter = this.getFilters().get(i);
            filter.destroy();
        }
    }
}

