/*
 * Decompiled with CFR 0.152.
 */
package com.github.bpazy.cqjavaapi.server;

import com.github.bpazy.cqjavaapi.handler.MessageHandler;
import com.github.bpazy.cqjavaapi.message.DiscussMessage;
import com.github.bpazy.cqjavaapi.message.GroupAdmin;
import com.github.bpazy.cqjavaapi.message.GroupMemberDecrease;
import com.github.bpazy.cqjavaapi.message.GroupMemberIncrease;
import com.github.bpazy.cqjavaapi.message.GroupMessage;
import com.github.bpazy.cqjavaapi.message.PrivateMessage;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqServer {
    private static final Logger logger = LoggerFactory.getLogger(CqServer.class);
    private static final int HEARTBEAT_INTERVAL = 5000;
    private List<MessageHandler> messageHandlers = new ArrayList<MessageHandler>();

    public void listenAndServe(int port) {
        this.heartbeatThread(port);
        this.receiveMessageThread(port);
    }

    private void receiveMessageThread(int port) {
        new Thread(() -> {
            try {
                DatagramSocket server = new DatagramSocket(port);
                Throwable throwable = null;
                try {
                    try {
                        byte[] buf = new byte[1024];
                        DatagramPacket packet = new DatagramPacket(buf, buf.length);
                        while (true) {
                            server.receive(packet);
                            String msg = this.buildMessage(packet);
                            if (this.isNotHeartbeatMsg(msg)) {
                                logger.debug("Got message: {}", (Object)msg);
                            }
                            this.dispatchMessage(msg);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (server != null) {
                        if (throwable != null) {
                            try {
                                server.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            server.close();
                        }
                    }
                    throw throwable3;
                }
            }
            catch (SocketException e) {
                logger.error("Server listenAndServe failed", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("server.receive failed", (Throwable)e);
            }
        }).start();
    }

    private boolean isNotHeartbeatMsg(String msg) {
        return !"ServerHello".equals(msg);
    }

    private void heartbeatThread(int port) {
        new Thread(() -> {
            try {
                DatagramSocket heartbeatSocket = new DatagramSocket();
                Throwable throwable = null;
                try {
                    try {
                        DatagramPacket heartbeatPacket = this.buildHeartbeatPacket("ClientHello " + port);
                        while (true) {
                            heartbeatSocket.send(heartbeatPacket);
                            Thread.sleep(5000L);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (heartbeatSocket != null) {
                        if (throwable != null) {
                            try {
                                heartbeatSocket.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            heartbeatSocket.close();
                        }
                    }
                    throw throwable3;
                }
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }).start();
    }

    private DatagramPacket buildHeartbeatPacket(String msg) throws UnknownHostException {
        byte[] bytes = msg.getBytes();
        return new DatagramPacket(bytes, bytes.length, InetAddress.getByName("127.0.0.1"), 11235);
    }

    private String buildMessage(DatagramPacket packet) {
        byte[] data = packet.getData();
        data = Arrays.copyOf(data, packet.getLength());
        return new String(data);
    }

    protected void dispatchMessage(String msg) {
        String[] args = msg.split(" ");
        switch (args[0]) {
            case "ServerHello": {
                break;
            }
            case "PrivateMessage": {
                MessageHandler handler;
                boolean finish;
                Iterator<MessageHandler> iterator = this.messageHandlers.iterator();
                while (iterator.hasNext() && !(finish = (handler = iterator.next()).privateMessage(new PrivateMessage(args[1], args[2])))) {
                }
                break;
            }
            case "GroupMessage": {
                MessageHandler handler;
                boolean finish;
                Iterator<MessageHandler> iterator = this.messageHandlers.iterator();
                while (iterator.hasNext() && !(finish = (handler = iterator.next()).groupMessage(new GroupMessage(args[1], args[2], args[3])))) {
                }
                break;
            }
            case "DiscussMessage": {
                MessageHandler handler;
                boolean finish;
                Iterator<MessageHandler> iterator = this.messageHandlers.iterator();
                while (iterator.hasNext() && !(finish = (handler = iterator.next()).discussMessage(new DiscussMessage(args[1], args[2], args[3])))) {
                }
                break;
            }
            case "GroupMemberDecrease": {
                MessageHandler handler;
                boolean finish;
                Iterator<MessageHandler> iterator = this.messageHandlers.iterator();
                while (iterator.hasNext() && !(finish = (handler = iterator.next()).groupMemberDecrease(new GroupMemberDecrease(args[1], args[2], args[3])))) {
                }
                break;
            }
            case "GroupMemberIncrease": {
                MessageHandler handler;
                boolean finish;
                Iterator<MessageHandler> iterator = this.messageHandlers.iterator();
                while (iterator.hasNext() && !(finish = (handler = iterator.next()).groupMemberIncrease(new GroupMemberIncrease(args[1], args[2], args[3])))) {
                }
                break;
            }
            case "GroupAdmin": {
                MessageHandler handler;
                boolean finish;
                Iterator<MessageHandler> iterator = this.messageHandlers.iterator();
                while (iterator.hasNext() && !(finish = (handler = iterator.next()).groupAdmin(new GroupAdmin(args[1], args[2], args[3])))) {
                }
                break;
            }
            default: {
                logger.warn("Unknown event, {}", (Object)msg);
            }
        }
    }

    public void addMessageHandler(MessageHandler handler) {
        this.messageHandlers.add(handler);
    }
}

