/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeinghelper.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateUtil {
    public static final String YYYYMMDD = "yyyy-MM-dd";
    public static final String YYYYMMDDHHMMSS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYYMMDDHHMMSSSSS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String YYYYMMDDHHMM_CHINESE = "yyyy\u5e74MM\u6708dd\u65e5HH\u70b9mm\u5206";
    public static final String YYYYMMDD_CHINESE = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String MMDD_CHINESE = "MM\u6708dd\u65e5";
    public static final long MILLISECONDS_FOR_ONE_MINUTE = 60000L;
    public static final long MILLISECONDS_FOR_ONE_HOUR = 3600000L;
    public static final long MILLISECONDS_FOR_ONE_DAY = 86400000L;

    public static Date getCurrentDate() {
        Calendar c = Calendar.getInstance();
        return DateUtil.stringToDate(DateUtil.dateToShortDateString(c.getTime()));
    }

    public static boolean isSameDay(Date date1, Date date2) {
        return DateUtil.calcIntervalDays(date1, date2) == 0;
    }

    public static Calendar toCalendar(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    public static int calcIntervalDays(String dateStr1, String dateStr2) {
        return DateUtil.calcIntervalDays(DateUtil.stringToDate(dateStr1), DateUtil.stringToDate(dateStr2));
    }

    public static int calcIntervalOurs(Date date1, Date date2) {
        if (date2.after(date1)) {
            return Long.valueOf((date2.getTime() - date1.getTime()) / 3600000L).intValue();
        }
        if (date2.before(date1)) {
            return Long.valueOf((date1.getTime() - date2.getTime()) / 3600000L).intValue();
        }
        return 0;
    }

    public static int calcIntervalMinutes(Date date1, Date date2) {
        if (date2.after(date1)) {
            return Long.valueOf((date2.getTime() - date1.getTime()) / 60000L).intValue();
        }
        if (date2.before(date1)) {
            return Long.valueOf((date1.getTime() - date2.getTime()) / 60000L).intValue();
        }
        return 0;
    }

    public static int calcIntervalDays(Date date1, Date date2) {
        if (date2.after(date1)) {
            return Long.valueOf((date2.getTime() - date1.getTime()) / 86400000L).intValue();
        }
        if (date2.before(date1)) {
            return Long.valueOf((date1.getTime() - date2.getTime()) / 86400000L).intValue();
        }
        return 0;
    }

    public static int dayOfWeek(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        int dayofWeek = ca.get(7) == 1 ? 7 : ca.get(7) - 1;
        return dayofWeek;
    }

    public static int getTodayMinutes() {
        Calendar ca = Calendar.getInstance();
        int hours = ca.get(11);
        int minutes = ca.get(12);
        return hours * 60 + minutes;
    }

    public static Date getIntervalDaysDate(Date time, int days) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(time);
        ca.add(5, days);
        return DateUtil.stringToDate(DateUtil.dateToShortDateString(ca.getTime()));
    }

    public static Date getIntervalHourDate(Date time, int hours) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(time);
        ca.add(10, hours);
        System.out.println(DateUtil.dateToString(ca.getTime(), YYYYMMDDHHMM_CHINESE));
        return ca.getTime();
    }

    public static String dateToShortDateString(Date date) {
        return DateUtil.dateToString(date, YYYYMMDD);
    }

    public static String dateToString(Date date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
        try {
            return dateFormat.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date stringToDate(String dateStr) {
        SimpleDateFormat format = null;
        if (dateStr.contains("/")) {
            format = dateStr.contains(":") && dateStr.contains(" ") ? new SimpleDateFormat("yyyy/MM/dd HH:mm:ss") : new SimpleDateFormat("yyyy/MM/dd");
        } else if (dateStr.contains("-")) {
            format = dateStr.contains(":") && dateStr.contains(" ") ? new SimpleDateFormat(YYYYMMDDHHMMSS) : new SimpleDateFormat(YYYYMMDD);
        } else if (dateStr.contains("\u5e74") && dateStr.contains("\u6708") && dateStr.contains("\u65e5")) {
            format = new SimpleDateFormat(YYYYMMDD_CHINESE);
        } else if (!dateStr.contains("\u5e74") && dateStr.contains("\u6708") && dateStr.contains("\u65e5")) {
            format = new SimpleDateFormat(MMDD_CHINESE);
        }
        if (format == null) {
            return null;
        }
        format.setTimeZone(TimeZone.getTimeZone("Asia/Shanghai"));
        try {
            return format.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String dateToVoString(Date date) {
        Date now = new Date();
        long deltaMilliSeconds = now.getTime() - date.getTime();
        Calendar dateCalendar = DateUtil.toCalendar(date);
        Calendar nowCalendar = DateUtil.toCalendar(now);
        if (nowCalendar.get(1) == dateCalendar.get(1)) {
            if (DateUtil.isSameDay(date, now)) {
                if (deltaMilliSeconds < 60000L) {
                    return "\u521a\u521a";
                }
                if (deltaMilliSeconds < 3600000L) {
                    return String.format("%d\u5206\u949f\u524d", deltaMilliSeconds / 60000L);
                }
                if (deltaMilliSeconds < 86400000L) {
                    return String.format("%d\u5c0f\u65f6\u524d", deltaMilliSeconds / 3600000L);
                }
            }
            if (DateUtil.isSameDay(date, DateUtil.getIntervalDaysDate(now, -1))) {
                return String.format("\u6628\u5929 %d:%02d", dateCalendar.get(11), dateCalendar.get(12));
            }
            return String.format("%d\u6708%d\u65e5 %d:%02d", dateCalendar.get(2) + 1, dateCalendar.get(5), dateCalendar.get(11), dateCalendar.get(12));
        }
        return String.format("%d\u5e74%d\u6708%d\u65e5 %d:%02d", dateCalendar.get(1), dateCalendar.get(2) + 1, dateCalendar.get(5), dateCalendar.get(11), dateCalendar.get(12));
    }

    public static Float getPercentage(Date date) {
        if (date == null) {
            date = new Date();
        }
        Integer day = DateUtil.getDay(date);
        Integer month = DateUtil.getMonth(date);
        Integer year = DateUtil.getYear(date);
        Integer monthDays = DateUtil.getMonthLastDay(year, month);
        return Float.valueOf((float)day.intValue() / (float)monthDays.intValue());
    }

    public static int getYear(Date date) {
        if (date == null) {
            date = new Date();
        }
        String year = new SimpleDateFormat("yyyy").format(date);
        return Integer.parseInt(year);
    }

    public static int getMonth(Date date) {
        String month = new SimpleDateFormat("MM").format(date);
        return Integer.parseInt(month);
    }

    public static int getDay(Date date) {
        String day = new SimpleDateFormat("dd").format(date);
        return Integer.parseInt(day);
    }

    public static int getMonthLastDay(int year, int month) {
        Calendar a = Calendar.getInstance();
        a.set(1, year);
        a.set(2, month - 1);
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    public static int getMonthFirstDay(int year, int month) {
        Calendar a = Calendar.getInstance();
        a.set(1, year);
        a.set(2, month);
        a.set(5, 1);
        int maxDate = a.get(5);
        return maxDate;
    }

    public static boolean isLeap(int year) {
        return year % 100 == 0 && year % 400 == 0 || year % 100 != 0 && year % 4 == 0;
    }

    public static Date startTime(Date time) {
        if (time == null) {
            time = new Date();
        }
        Calendar todayStart = Calendar.getInstance();
        todayStart.setTime(time);
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime();
    }

    public static Date endTime(Date time) {
        if (time == null) {
            time = new Date();
        }
        Calendar todayStart = Calendar.getInstance();
        todayStart.setTime(time);
        todayStart.set(11, 23);
        todayStart.set(12, 59);
        todayStart.set(13, 59);
        todayStart.set(14, 999);
        return todayStart.getTime();
    }

    public static Date addSeconds(Integer seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, seconds);
        return calendar.getTime();
    }

    public static Date getNow() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }
}

