/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.utilities;

import com.github.collinalpert.java2db.annotations.ForeignKeyObject;
import com.github.collinalpert.java2db.annotations.TableName;
import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.database.TableNameColumn;
import com.github.collinalpert.java2db.entities.BaseEntity;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class Utilities {
    public static List<Field> getEntityFields(Class<? extends BaseEntity> instanceClass) {
        return Utilities.getEntityFields(instanceClass, null, false);
    }

    public static List<Field> getEntityFields(Class<? extends BaseEntity> instanceClass, boolean includeForeignKeys) {
        return Utilities.getEntityFields(instanceClass, null, includeForeignKeys);
    }

    public static List<Field> getEntityFields(Class<? extends BaseEntity> instanceClass, Class<?> delimiter) {
        return Utilities.getEntityFields(instanceClass, delimiter, false);
    }

    private static <T extends BaseEntity> List<Field> getEntityFields(Class<? super T> instanceClass, Class<?> delimiter, boolean includeForeignKeys) {
        LinkedList<Field> fields = new LinkedList<Field>();
        do {
            fields.addAll(Arrays.asList(instanceClass.getDeclaredFields()));
            if (includeForeignKeys) continue;
            fields.removeIf(x -> x.getAnnotation(ForeignKeyObject.class) != null);
        } while ((instanceClass = instanceClass.getSuperclass()) != delimiter);
        return fields;
    }

    public static List<TableNameColumn> getAllFields(Class<? extends BaseEntity> instanceClass) {
        LinkedList<TableNameColumn> fields = new LinkedList<TableNameColumn>();
        for (Field field : Utilities.getEntityFields(instanceClass, true)) {
            fields.add(new TableNameColumn(Utilities.getTableName(instanceClass), field));
            if (field.getAnnotation(ForeignKeyObject.class) == null) continue;
            fields.addAll(Utilities.getAllFields(field.getType()));
        }
        return fields;
    }

    public static void log(Object text) {
        if (DBConnection.LOG_QUERIES) {
            System.out.println(text);
        }
    }

    public static void logf(String text, Object ... params) {
        Utilities.log(String.format(text, params));
    }

    public static String getTableName(Class<?> type) {
        TableName tableNameAnnotation = type.getAnnotation(TableName.class);
        if (tableNameAnnotation == null) {
            return type.getSimpleName().toLowerCase();
        }
        return tableNameAnnotation.value();
    }
}

