/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries;

import com.github.collinalpert.java2db.annotations.ForeignKeyObject;
import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.database.ForeignKeyReference;
import com.github.collinalpert.java2db.database.TableNameColumnReference;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.mappers.BaseMapper;
import com.github.collinalpert.java2db.queries.OrderClause;
import com.github.collinalpert.java2db.queries.OrderTypes;
import com.github.collinalpert.java2db.queries.QueryConstraints;
import com.github.collinalpert.java2db.utilities.Utilities;
import com.github.collinalpert.lambda2sql.Lambda2Sql;
import com.github.collinalpert.lambda2sql.functions.SqlFunction;
import com.github.collinalpert.lambda2sql.functions.SqlPredicate;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class Query<T extends BaseEntity> {
    private final Class<T> type;
    private final BaseMapper<T> mapper;
    private SqlPredicate<T> whereClause;
    private OrderClause<T> orderByClause;
    private Integer limit;

    public Query(Class<T> type, BaseMapper<T> mapper) {
        this.type = type;
        this.mapper = mapper;
    }

    public Optional<T> getFirst() {
        DBConnection connection = new DBConnection();
        try {
            String query = this.buildQuery();
            Utilities.log(query);
            Optional<T> optional = this.mapper.map(connection.execute(query));
            connection.close();
            return optional;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }
    }

    public List<T> get() {
        DBConnection connection = new DBConnection();
        try {
            String query = this.buildQuery();
            Utilities.log(query);
            List<T> list = this.mapper.mapToList(connection.execute(query));
            connection.close();
            return list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }
    }

    public Query<T> where(SqlPredicate<T> predicate) {
        if (this.whereClause != null) {
            this.whereClause = this.whereClause.and(predicate);
            return this;
        }
        this.whereClause = predicate;
        return this;
    }

    public Query<T> orderBy(SqlFunction<T, ?> function) {
        return this.orderBy(function, OrderTypes.ASCENDING);
    }

    public Query<T> orderBy(SqlFunction<T, ?> function, OrderTypes type) {
        this.orderByClause = new OrderClause<T>(function, type);
        return this;
    }

    public Query<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    private String buildQuery() {
        StringBuilder builder = new StringBuilder("select ");
        LinkedList<String> fieldList = new LinkedList<String>();
        LinkedList<ForeignKeyReference> foreignKeyList = new LinkedList<ForeignKeyReference>();
        String tableName = String.format("`%s`", Utilities.getTableName(this.type));
        List<TableNameColumnReference> columns = Utilities.getAllFields(this.type);
        for (TableNameColumnReference column : columns) {
            if (column.isForeignKey()) {
                foreignKeyList.add(new ForeignKeyReference(column.getReference(), column.getColumn().getAnnotation(ForeignKeyObject.class).value(), Utilities.getTableName(column.getColumn().getType()), column.getAlias()));
                continue;
            }
            fieldList.add(String.format("%s as %s", column.getSQLNotation(), column.getAliasNotation()));
        }
        builder.append(String.join((CharSequence)", ", fieldList)).append(" from ").append(tableName);
        for (ForeignKeyReference foreignKey : foreignKeyList) {
            builder.append(" inner join `").append(foreignKey.getChildTable()).append("` ").append(foreignKey.getAlias()).append(" on `").append(foreignKey.getParentClass()).append("`.").append(foreignKey.getParentForeignKey()).append(" = ").append(foreignKey.getAlias()).append(".id");
        }
        SqlPredicate<T> constraints = QueryConstraints.getConstraints(this.type);
        this.whereClause = this.whereClause == null ? constraints : this.whereClause.and(constraints);
        String whereSQL = Lambda2Sql.toSql(this.whereClause, tableName);
        builder.append(" where ").append(whereSQL);
        if (this.orderByClause != null) {
            builder.append(" order by ").append(Lambda2Sql.toSql(this.orderByClause.getFunction(), tableName)).append(" ").append(this.orderByClause.getOrderType().getSql());
        }
        if (this.limit != null) {
            builder.append(" limit ").append(this.limit);
        }
        return builder.toString();
    }

    public String getQuery() {
        return this.buildQuery();
    }

    public String toString() {
        return this.buildQuery();
    }
}

