/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries;

import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.lambda2sql.functions.SqlPredicate;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class QueryConstraints {
    private static Map<Class<? extends BaseEntity>, SqlPredicate<? extends BaseEntity>> selectConstraints = new HashMap<Class<? extends BaseEntity>, SqlPredicate<? extends BaseEntity>>();

    public static <E extends BaseEntity> SqlPredicate<E> getConstraints(Class<E> clazz) {
        if (clazz == BaseEntity.class) {
            return selectConstraints.getOrDefault(BaseEntity.class, (SqlPredicate<? extends BaseEntity>)(SqlPredicate & Serializable)x -> true);
        }
        SqlPredicate<? extends BaseEntity> existingPredicate = selectConstraints.getOrDefault(clazz, (SqlPredicate<? extends BaseEntity>)(SqlPredicate & Serializable)x -> true);
        Class<E> superClass = clazz.getSuperclass();
        return existingPredicate.and(QueryConstraints.getConstraints(superClass));
    }

    public static <E extends BaseEntity> void addConstraint(Class<E> clazz, SqlPredicate<E> predicate) {
        if (selectConstraints.containsKey(clazz)) {
            SqlPredicate<? extends BaseEntity> existingPredicate = selectConstraints.get(clazz);
            selectConstraints.replace(clazz, (SqlPredicate<? extends BaseEntity>)existingPredicate.and(predicate));
            return;
        }
        selectConstraints.put(clazz, predicate);
    }
}

