/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.services;

import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.mappers.BaseMapper;
import com.github.collinalpert.java2db.queries.OrderTypes;
import com.github.collinalpert.java2db.queries.Query;
import com.github.collinalpert.java2db.utilities.IoC;
import com.github.collinalpert.java2db.utilities.Utilities;
import com.github.collinalpert.lambda2sql.Lambda2Sql;
import com.github.collinalpert.lambda2sql.functions.SqlFunction;
import com.github.collinalpert.lambda2sql.functions.SqlPredicate;
import java.lang.reflect.ParameterizedType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class BaseService<T extends BaseEntity> {
    private final Class<T> type;
    private final String tableName;
    private final BaseMapper<T> baseMapper;
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");

    protected BaseService() {
        this.type = this.getGenericType();
        this.baseMapper = new BaseMapper<T>(this.type);
        this.tableName = String.format("`%s`", Utilities.getTableName(this.type));
    }

    public void create(T instance) throws SQLException {
        StringBuilder insertQuery = new StringBuilder("insert into ").append(this.tableName).append(" (");
        String databaseFields = Utilities.getEntityFields(instance.getClass()).stream().map(field -> String.format("`%s`", field.getName())).collect(Collectors.joining(", "));
        insertQuery.append(databaseFields).append(") values");
        ArrayList<String> values = new ArrayList<String>();
        Utilities.getEntityFields(instance.getClass(), BaseEntity.class).forEach(field -> {
            field.setAccessible(true);
            try {
                Object value = field.get(instance);
                if (value == null) {
                    values.add("null");
                    return;
                }
                if (value instanceof String) {
                    values.add(String.format("'%s'", value));
                    return;
                }
                if (value instanceof Boolean) {
                    boolean bool = (Boolean)value;
                    values.add(Integer.toString(bool ? 1 : 0));
                    return;
                }
                if (value instanceof LocalDateTime) {
                    LocalDateTime dateTime = (LocalDateTime)value;
                    values.add(String.format("'%s'", this.dateTimeFormatter.format(dateTime)));
                    return;
                }
                if (value instanceof LocalDate) {
                    LocalDate date = (LocalDate)value;
                    values.add(String.format("'%s'", this.dateFormatter.format(date)));
                    return;
                }
                if (value instanceof LocalTime) {
                    LocalTime time = (LocalTime)value;
                    values.add(String.format("'%s'", this.timeFormatter.format(time)));
                    return;
                }
                values.add(value.toString());
            }
            catch (IllegalAccessException e) {
                System.err.printf("Unable to get value from field %s for type %s\n", field.getName(), this.type.getSimpleName());
            }
        });
        values.add("default");
        insertQuery.append(" (").append(String.join((CharSequence)", ", values)).append(")");
        try (DBConnection connection = new DBConnection();){
            connection.update(insertQuery.toString());
            Utilities.logf("%s successfully created!", this.type.getSimpleName());
        }
    }

    public long count() {
        return this.count(x -> true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long count(SqlPredicate<T> predicate) {
        try (DBConnection connection = new DBConnection();){
            long l;
            block17: {
                ResultSet result;
                block15: {
                    long l2;
                    block16: {
                        result = connection.execute(String.format("select count(*) from %s where %s", this.tableName, Lambda2Sql.toSql(predicate, this.tableName)));
                        try {
                            if (!result.next()) break block15;
                            l2 = result.getLong("count(*)");
                            if (result == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return l2;
                }
                l = 0L;
                if (result == null) break block17;
                result.close();
            }
            return l;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Could not get amount of rows for this predicate.");
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean any() {
        try (DBConnection connection = new DBConnection();){
            boolean bl;
            block17: {
                ResultSet result;
                block15: {
                    boolean bl2;
                    block16: {
                        result = connection.execute(String.format("select count(*) from (select 1 from %s limit 1) as x", this.tableName));
                        try {
                            if (!result.next()) break block15;
                            boolean bl3 = bl2 = result.getLong("count(*)") == 1L;
                            if (result == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return bl2;
                }
                bl = false;
                if (result == null) break block17;
                result.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Could not check if this table has any rows.");
        }
    }

    public boolean any(SqlPredicate<T> predicate) {
        return this.count(predicate) > 0L;
    }

    private Query<T> query() {
        if (IoC.isMapperRegistered(this.type)) {
            return new Query<T>(this.type, IoC.resolveMapper(this.type));
        }
        return new Query<T>(this.type, this.baseMapper);
    }

    protected Optional<T> getSingle(SqlPredicate<T> predicate) {
        return this.query().where(predicate).getFirst();
    }

    protected Query<T> getMultiple(SqlPredicate<T> predicate) {
        return this.query().where(predicate);
    }

    public Optional<T> getById(long id) {
        return this.getSingle(x -> x.getId() == id);
    }

    public List<T> getAll() {
        return this.getMultiple(x -> true).get();
    }

    public List<T> getAll(int limit) {
        return this.getMultiple(x -> true).limit(limit).get();
    }

    public List<T> getAll(SqlFunction<T, ?> orderBy) {
        return this.getAll(orderBy, OrderTypes.ASCENDING);
    }

    public List<T> getAll(SqlFunction<T, ?> orderBy, OrderTypes sortingType) {
        return this.getMultiple(x -> true).orderBy(orderBy, sortingType).get();
    }

    public List<T> getAll(SqlFunction<T, ?> orderBy, int limit) {
        return this.getAll(orderBy, OrderTypes.ASCENDING, limit);
    }

    public List<T> getAll(SqlFunction<T, ?> orderBy, OrderTypes sortingType, int limit) {
        return this.getMultiple(x -> true).orderBy(orderBy, sortingType).limit(limit).get();
    }

    public void update(T instance) throws SQLException {
        StringBuilder updateQuery = new StringBuilder("update ").append(this.tableName).append(" set ");
        ArrayList fieldSetterList = new ArrayList();
        Utilities.getEntityFields(instance.getClass(), BaseEntity.class).forEach(field -> {
            field.setAccessible(true);
            try {
                Object value = field.get(instance);
                if (value == null) {
                    fieldSetterList.add(String.format("`%s` = null", field.getName()));
                }
                if (value instanceof String) {
                    fieldSetterList.add(String.format("`%s` = '%s'", field.getName(), value));
                    return;
                }
                if (value instanceof Boolean) {
                    boolean bool = (Boolean)value;
                    fieldSetterList.add(String.format("`%s` = %d", field.getName(), bool ? 1 : 0));
                    return;
                }
                if (value instanceof LocalDateTime) {
                    LocalDateTime dateTime = (LocalDateTime)value;
                    fieldSetterList.add(String.format("`%s` = '%s'", field.getName(), this.dateTimeFormatter.format(dateTime)));
                    return;
                }
                if (value instanceof LocalDate) {
                    LocalDate date = (LocalDate)value;
                    fieldSetterList.add(String.format("`%s` = '%s'", field.getName(), this.dateFormatter.format(date)));
                    return;
                }
                if (value instanceof LocalTime) {
                    LocalTime time = (LocalTime)value;
                    fieldSetterList.add(String.format("`%s` = '%s'", field.getName(), this.timeFormatter.format(time)));
                    return;
                }
                fieldSetterList.add(String.format("`%s` = %s", field.getName(), value));
            }
            catch (IllegalAccessException e) {
                System.err.printf("Error getting value for field %s from type %s\n", field.getName(), this.type.getSimpleName());
            }
        });
        updateQuery.append(String.join((CharSequence)", ", fieldSetterList)).append(" where id = ").append(((BaseEntity)instance).getId());
        try (DBConnection connection = new DBConnection();){
            connection.update(updateQuery.toString());
            Utilities.logf("%s with id %d was successfully updated", this.type.getSimpleName(), ((BaseEntity)instance).getId());
        }
    }

    public void delete(T instance) throws SQLException {
        this.delete(((BaseEntity)instance).getId());
    }

    public void delete(long id) throws SQLException {
        try (DBConnection connection = new DBConnection();){
            connection.update(String.format("delete from %s where %s.id = ?", this.tableName, this.tableName), id);
            Utilities.logf("%s with id %s successfully deleted!", this.type.getSimpleName(), id);
        }
    }

    public void delete(SqlPredicate<T> predicate) throws SQLException {
        try (DBConnection connection = new DBConnection();){
            connection.update(String.format("delete from %s where %s", this.tableName, Lambda2Sql.toSql(predicate, this.tableName)));
            Utilities.logf("%s successfully deleted!", this.type.getSimpleName());
        }
    }

    private Class<T> getGenericType() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }
}

