/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.mappers;

import com.github.collinalpert.java2db.annotations.ColumnName;
import com.github.collinalpert.java2db.annotations.ForeignKeyEntity;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.mappers.IMapper;
import com.github.collinalpert.java2db.utilities.IoC;
import com.github.collinalpert.java2db.utilities.UniqueIdentifier;
import com.github.collinalpert.java2db.utilities.Utilities;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class BaseMapper<T extends BaseEntity>
implements IMapper<T> {
    private Class<T> clazz;

    public BaseMapper(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Optional<T> map(ResultSet set) throws SQLException {
        BaseEntity entity = (BaseEntity)IoC.createInstance(this.clazz);
        if (!set.next()) {
            UniqueIdentifier.unset();
            return Optional.empty();
        }
        this.setFields(set, entity);
        set.close();
        UniqueIdentifier.unset();
        return Optional.of(entity);
    }

    @Override
    public List<T> mapToList(ResultSet set) throws SQLException {
        LinkedList list = new LinkedList();
        this.mapInternal(set, list::add);
        return list;
    }

    @Override
    public Stream<T> mapToStream(ResultSet set) throws SQLException {
        Stream.Builder builder = Stream.builder();
        this.mapInternal(set, builder::add);
        return builder.build();
    }

    private void mapInternal(ResultSet set, Consumer<T> handling) throws SQLException {
        while (set.next()) {
            BaseEntity entity = (BaseEntity)IoC.createInstance(this.clazz);
            this.setFields(set, entity);
            handling.accept(entity);
        }
        set.close();
        UniqueIdentifier.unset();
    }

    @Override
    public T[] mapToArray(ResultSet set) throws SQLException {
        BaseEntity[] array = (BaseEntity[])Array.newInstance(this.clazz, 20);
        int index = 0;
        while (set.next()) {
            if (array.length - 1 == index) {
                array = this.createCopy(array, array.length + 20, array.length);
            }
            BaseEntity entity = (BaseEntity)IoC.createInstance(this.clazz);
            this.setFields(set, entity);
            array[index++] = entity;
        }
        UniqueIdentifier.unset();
        set.close();
        return this.trimArray(array);
    }

    private T[] trimArray(T[] array) {
        int lastElement = 0;
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] == null) continue;
            lastElement = i;
            break;
        }
        return this.createCopy((BaseEntity[])array, lastElement + 1, lastElement + 1);
    }

    private T[] createCopy(T[] oldArray, int newLength, int elementsToCopy) {
        BaseEntity[] newArray = (BaseEntity[])Array.newInstance(this.clazz, newLength);
        System.arraycopy(oldArray, 0, newArray, 0, elementsToCopy);
        return newArray;
    }

    private <E extends BaseEntity> void setFields(ResultSet set, E entity) throws SQLException {
        this.setFields(set, entity, null);
    }

    private <E extends BaseEntity> void setFields(ResultSet set, E entity, String identifier) throws SQLException {
        List<Field> fields = Utilities.getEntityFields(entity.getClass(), true);
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.getAnnotation(ForeignKeyEntity.class) != null) {
                String foreignKeyName;
                block6: {
                    String foreignKeyColumnName = field.getAnnotation(ForeignKeyEntity.class).value();
                    if (!BaseEntity.class.isAssignableFrom(field.getType())) {
                        throw new IllegalArgumentException(String.format("Type %s, which is annotated as a foreign key, does not extend BaseEntity.", field.getType().getSimpleName()));
                    }
                    foreignKeyName = "";
                    try {
                        Field foreignKeyField = field.getDeclaringClass().getDeclaredField(foreignKeyColumnName);
                        foreignKeyName = foreignKeyField.getName();
                        if (foreignKeyField.getAnnotation(ColumnName.class) == null) break block6;
                        foreignKeyName = foreignKeyField.getAnnotation(ColumnName.class).value();
                    }
                    catch (NoSuchFieldException e) {
                        for (Field declaredField : field.getDeclaringClass().getDeclaredFields()) {
                            if (declaredField.getAnnotation(ColumnName.class) == null || !declaredField.getAnnotation(ColumnName.class).value().equals(foreignKeyColumnName)) continue;
                            foreignKeyName = declaredField.getAnnotation(ColumnName.class).value();
                            break;
                        }
                    }
                }
                if (set.getObject((identifier == null ? Utilities.getTableName(entity.getClass()) : identifier) + "_" + foreignKeyName) == null) continue;
                BaseEntity foreignKeyObject = (BaseEntity)IoC.createInstance(field.getType());
                this.setFields(set, foreignKeyObject, UniqueIdentifier.getIdentifier(field.getName()));
                Utilities.tryAction(() -> field.set(entity, foreignKeyObject));
                continue;
            }
            String columnName = Utilities.getColumnName(field);
            String columnLabel = (identifier == null ? Utilities.getTableName(entity.getClass()) : identifier) + "_" + columnName;
            Object value = field.getType() == LocalDateTime.class ? set.getTimestamp(columnLabel, Calendar.getInstance(Locale.getDefault())).toLocalDateTime() : (field.getType() == LocalDate.class ? set.getDate(columnLabel, Calendar.getInstance(Locale.getDefault())).toLocalDate() : (field.getType() == LocalTime.class ? set.getTime(columnLabel, Calendar.getInstance(Locale.getDefault())).toLocalTime() : set.getObject(columnLabel)));
            if (value == null) continue;
            Utilities.tryAction(() -> field.set(entity, value));
        }
    }
}

