/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.mappers;

import com.github.collinalpert.java2db.annotations.ColumnName;
import com.github.collinalpert.java2db.annotations.ForeignKeyEntity;
import com.github.collinalpert.java2db.contracts.IdentifiableEnum;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.mappers.Mappable;
import com.github.collinalpert.java2db.modules.AnnotationModule;
import com.github.collinalpert.java2db.modules.ArrayModule;
import com.github.collinalpert.java2db.modules.FieldModule;
import com.github.collinalpert.java2db.modules.TableModule;
import com.github.collinalpert.java2db.utilities.IoC;
import com.github.collinalpert.java2db.utilities.Utilities;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class EntityMapper<E extends BaseEntity>
implements Mappable<E> {
    private static final TableModule tableModule = TableModule.getInstance();
    private Class<E> clazz;
    private final Map<String, String> aliases;

    public EntityMapper(Class<E> clazz) {
        this.clazz = clazz;
        this.aliases = FieldModule.getInstance().getAliases(clazz);
    }

    @Override
    public Optional<E> map(ResultSet set) throws SQLException {
        BaseEntity entity = (BaseEntity)IoC.createInstance(this.clazz);
        if (!set.next()) {
            return Optional.empty();
        }
        this.setFields(set, entity);
        set.close();
        return Optional.of(entity);
    }

    @Override
    public List<E> mapToList(ResultSet set) throws SQLException {
        ArrayList list = new ArrayList();
        this.mapInternal(set, list::add);
        return list;
    }

    @Override
    public Stream<E> mapToStream(ResultSet set) throws SQLException {
        Stream.Builder builder = Stream.builder();
        this.mapInternal(set, builder::add);
        return builder.build();
    }

    @Override
    public E[] mapToArray(ResultSet set) throws SQLException {
        ArrayModule<E> module = new ArrayModule<E>(this.clazz, 20);
        this.mapInternal(set, module::addElement);
        return (BaseEntity[])module.getArray();
    }

    @Override
    public <K, V> Map<K, V> mapToMap(ResultSet set, Function<E, K> keyMapping, Function<E, V> valueMapping) throws SQLException {
        HashMap map = new HashMap();
        this.mapInternal(set, x -> map.put(keyMapping.apply(x), valueMapping.apply(x)));
        return map;
    }

    private void mapInternal(ResultSet set, Consumer<E> handling) throws SQLException {
        while (set.next()) {
            BaseEntity entity = (BaseEntity)IoC.createInstance(this.clazz);
            this.setFields(set, entity);
            handling.accept(entity);
        }
        set.close();
    }

    private <TEntity extends BaseEntity> void setFields(ResultSet set, TEntity entity) throws SQLException {
        this.setFields(set, entity, tableModule.getTableName(entity.getClass()));
    }

    private <TEntity extends BaseEntity> void setFields(ResultSet set, TEntity entity, String identifier) throws SQLException {
        FieldModule fieldModule = FieldModule.getInstance();
        List<Field> fields = fieldModule.getEntityFields(entity.getClass(), true);
        for (Field field : fields) {
            Object value;
            field.setAccessible(true);
            if (field.getAnnotation(ForeignKeyEntity.class) != null) {
                if (field.getType().isEnum()) {
                    if (!IdentifiableEnum.class.isAssignableFrom(field.getType())) {
                        throw new IllegalArgumentException(String.format("The enum %s used in %s was annotated with a ForeignKeyEntity attribute but does not extend IdentifiableEnum.", field.getType().getSimpleName(), field.getDeclaringClass().getSimpleName()));
                    }
                    String foreignKeyName = this.getForeignKeyName(field);
                    value = Utilities.tryGetValue(() -> this.getAccessibleField(field.getDeclaringClass(), foreignKeyName).get(entity));
                    if (value == null) continue;
                    Optional<IdentifiableEnum> foundEnum = Arrays.stream(field.getType().getEnumConstants()).map((? super T x) -> (IdentifiableEnum)x).filter(x -> Long.parseLong(value.toString()) == x.getId()).findFirst();
                    foundEnum.ifPresent(identifiableEnum -> Utilities.tryAction(() -> field.set(entity, field.getType().cast(identifiableEnum))));
                    continue;
                }
                if (!BaseEntity.class.isAssignableFrom(field.getType())) {
                    throw new IllegalArgumentException(String.format("Type %s, which is annotated as a foreign key, does not extend BaseEntity.", field.getType().getSimpleName()));
                }
                if (set.getObject(String.join((CharSequence)"_", identifier, this.getForeignKeyName(field))) == null) continue;
                BaseEntity foreignKeyObject = (BaseEntity)IoC.createInstance(field.getType());
                this.setFields(set, foreignKeyObject, this.aliases.get(field.getDeclaringClass().getSimpleName().toLowerCase() + "_" + field.getName()));
                Utilities.tryAction(() -> field.set(entity, foreignKeyObject));
                continue;
            }
            String columnLabel = String.join((CharSequence)"_", identifier, tableModule.getColumnName(field));
            value = this.getValue(set, columnLabel, field.getType());
            if (value == null) continue;
            Utilities.tryAction(() -> field.set(entity, value));
        }
    }

    private Object getValue(ResultSet set, String columnLabel, Class<?> type) throws SQLException {
        if (type == LocalDateTime.class) {
            Timestamp value = set.getTimestamp(columnLabel, Calendar.getInstance(Locale.getDefault()));
            return value == null ? null : value.toLocalDateTime();
        }
        if (type == LocalDate.class) {
            Date value = set.getDate(columnLabel, Calendar.getInstance(Locale.getDefault()));
            return value == null ? null : value.toLocalDate();
        }
        if (type == LocalTime.class) {
            Time value = set.getTime(columnLabel, Calendar.getInstance(Locale.getDefault()));
            return value == null ? null : value.toLocalTime();
        }
        return set.getObject(columnLabel);
    }

    private String getForeignKeyName(Field field) {
        AnnotationModule annotationModule = AnnotationModule.getInstance();
        String foreignKeyColumnName = field.getAnnotation(ForeignKeyEntity.class).value();
        try {
            Field foreignKeyField = field.getDeclaringClass().getDeclaredField(foreignKeyColumnName);
            return tableModule.getColumnName(foreignKeyField);
        }
        catch (NoSuchFieldException e) {
            for (Field declaredField : field.getDeclaringClass().getDeclaredFields()) {
                AnnotationModule.AnnotationInfo<ColumnName> info = annotationModule.getAnnotationInfo(declaredField, ColumnName.class, a -> a.value().equals(foreignKeyColumnName));
                if (!info.hasAnnotation()) continue;
                return info.getAnnotation().value();
            }
            return "";
        }
    }

    private Field getAccessibleField(Class<?> clazz, String name) throws NoSuchFieldException {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        return field;
    }
}

