/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries;

import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.database.ForeignKeyReference;
import com.github.collinalpert.java2db.database.TableColumnReference;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.mappers.EntityMapper;
import com.github.collinalpert.java2db.mappers.Mappable;
import com.github.collinalpert.java2db.modules.FieldModule;
import com.github.collinalpert.java2db.modules.TableModule;
import com.github.collinalpert.java2db.queries.QueryConstraints;
import com.github.collinalpert.java2db.queries.SingleEntityProjectionQuery;
import com.github.collinalpert.java2db.queries.SingleQueryable;
import com.github.collinalpert.java2db.utilities.IoC;
import com.github.collinalpert.lambda2sql.Lambda2Sql;
import com.github.collinalpert.lambda2sql.functions.SqlFunction;
import com.github.collinalpert.lambda2sql.functions.SqlPredicate;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class SingleEntityQuery<E extends BaseEntity>
implements SingleQueryable<E> {
    protected static final TableModule tableModule = TableModule.getInstance();
    protected final Class<E> type;
    protected final Mappable<E> mapper;
    private SqlPredicate<E> whereClause;

    public SingleEntityQuery(Class<E> type) {
        this.type = type;
        this.mapper = IoC.resolveMapper(type, new EntityMapper<E>(type));
    }

    public SingleEntityQuery<E> where(SqlPredicate<E> predicate) {
        this.whereClause = this.whereClause == null ? predicate : this.whereClause.and(predicate);
        return this;
    }

    public SingleEntityQuery<E> orWhere(SqlPredicate<E> predicate) {
        this.whereClause = this.whereClause == null ? predicate : this.whereClause.or(predicate);
        return this;
    }

    public <R> SingleQueryable<R> project(SqlFunction<E, R> projection) {
        return new SingleEntityProjectionQuery<E, R>(projection, this);
    }

    @Override
    public Optional<E> first() {
        DBConnection connection = new DBConnection();
        try {
            Optional<E> optional = this.mapper.map(connection.execute(this.getQuery()));
            connection.close();
            return optional;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }
    }

    @Override
    public String getQuery() {
        StringBuilder builder = new StringBuilder("select ");
        LinkedList<String> fieldList = new LinkedList<String>();
        String tableName = tableModule.getTableName(this.type);
        List<TableColumnReference> columns = FieldModule.getInstance().getColumnReferences(this.type);
        Iterator<TableColumnReference> columnIterator = columns.iterator();
        while (columnIterator.hasNext()) {
            TableColumnReference column = columnIterator.next();
            if (column instanceof ForeignKeyReference) continue;
            fieldList.add(String.format("%s as %s", column.getSQLNotation(), column.getAliasNotation()));
            columnIterator.remove();
        }
        builder.append(String.join((CharSequence)", ", fieldList)).append(" from `").append(tableName).append("`");
        for (TableColumnReference column : columns) {
            ForeignKeyReference foreignKey = (ForeignKeyReference)column;
            builder.append(" ").append(foreignKey.getJoinType().getSqlKeyword()).append(" join `").append(foreignKey.getForeignKeyTableName()).append("` ").append(foreignKey.getForeignKeyAlias()).append(" on `").append(foreignKey.getAlias()).append("`.`").append(foreignKey.getForeignKeyColumnName()).append("` = `").append(foreignKey.getForeignKeyAlias()).append("`.`id`");
        }
        builder.append(this.getQueryClauses(tableName));
        return builder.toString();
    }

    String getQueryClauses(String tableName) {
        StringBuilder builder = new StringBuilder();
        this.buildWhereClause(builder, tableName);
        builder.append(" limit 1");
        return builder.toString();
    }

    protected void buildWhereClause(StringBuilder builder, String tableName) {
        SqlPredicate<E> constraints = QueryConstraints.getConstraints(this.type);
        SqlPredicate<E> clauseCopy = this.whereClause;
        clauseCopy = clauseCopy == null ? constraints : clauseCopy.and(constraints);
        builder.append(" where ").append(Lambda2Sql.toSql(clauseCopy, tableName));
    }

    public String getTableName() {
        return tableModule.getTableName(this.type);
    }
}

