/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries;

import com.github.collinalpert.java2db.database.ConnectionConfiguration;
import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.queries.QueryParameters;
import com.github.collinalpert.java2db.queries.Queryable;
import com.github.collinalpert.java2db.queries.builder.IQueryBuilder;
import com.github.collinalpert.java2db.queries.builder.ProjectionQueryBuilder;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class SingleEntityProjectionQuery<E extends BaseEntity, R>
implements Queryable<R> {
    private final Class<R> returnType;
    private final IQueryBuilder<E> queryBuilder;
    private final QueryParameters<E> queryParameters;
    private final ConnectionConfiguration connectionConfiguration;

    public SingleEntityProjectionQuery(Class<R> returnType, ProjectionQueryBuilder<E, R> queryBuilder, QueryParameters<E> queryParameters, ConnectionConfiguration connectionConfiguration) {
        this.returnType = returnType;
        this.queryBuilder = queryBuilder;
        this.queryParameters = queryParameters;
        this.connectionConfiguration = connectionConfiguration;
    }

    @Override
    public Optional<R> first() {
        return this.resultHandling(Optional::ofNullable, Optional::empty);
    }

    @Override
    public List<R> toList() {
        return this.resultHandling(Collections::singletonList, Collections::emptyList);
    }

    @Override
    public Stream<R> toStream() {
        return this.resultHandling(Stream::of, Stream::empty);
    }

    @Override
    public R[] toArray() {
        Function<Object, Object[]> arrayMapping = databaseObject -> {
            Object[] array = (Object[])Array.newInstance(this.returnType, 1);
            array[0] = databaseObject;
            return array;
        };
        return this.resultHandling(arrayMapping, () -> (Object[])Array.newInstance(this.returnType, 0));
    }

    @Override
    public <K, V> Map<K, V> toMap(Function<R, K> keyMapping, Function<R, V> valueMapping) {
        return this.resultHandling(databaseObject -> Collections.singletonMap(keyMapping.apply(databaseObject), valueMapping.apply(databaseObject)), Collections::emptyMap);
    }

    @Override
    public Set<R> toSet() {
        return this.resultHandling(Collections::singleton, Collections::emptySet);
    }

    @Override
    public String getQuery() {
        return this.queryBuilder.build(this.queryParameters);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <D> D resultHandling(Function<R, D> valueConsumer, Supplier<D> defaultValueFactory) {
        try (DBConnection connection = new DBConnection(this.connectionConfiguration);){
            D d;
            block17: {
                ResultSet result;
                block15: {
                    D d2;
                    block16: {
                        result = connection.execute(this.getQuery());
                        try {
                            if (!result.next()) break block15;
                            d2 = valueConsumer.apply(result.getObject(1, this.returnType));
                            if (result == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return d2;
                }
                d = defaultValueFactory.get();
                if (result == null) break block17;
                result.close();
            }
            return d;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return defaultValueFactory.get();
        }
    }
}

