/*
 * Decompiled with CFR 0.152.
 */
package com.trigersoft.jaque.expression;

import com.trigersoft.jaque.expression.Expression;
import com.trigersoft.jaque.expression.ExpressionVisitor;
import com.trigersoft.jaque.expression.InvocableExpression;
import com.trigersoft.jaque.expression.LambdaExpression;
import com.trigersoft.jaque.expression.ParameterExpression;
import com.trigersoft.jaque.expression.TypeConverter;
import java.util.List;

public final class InvocationExpression
extends Expression {
    private final InvocableExpression _method;
    private final List<Expression> _arguments;

    InvocationExpression(InvocableExpression method, List<Expression> arguments) {
        super(14, method.getResultType());
        List<ParameterExpression> pp = method.getParameters();
        for (int i = 0; i < pp.size(); ++i) {
            Class<?> paramType;
            Class<?> resultType = arguments.get(i).getResultType();
            if (resultType == Object.class || TypeConverter.isAssignable(paramType = pp.get(i).getResultType(), resultType) || paramType.isInterface() && resultType == LambdaExpression.class) continue;
            throw new IllegalArgumentException(String.valueOf(i));
        }
        this._method = method;
        this._arguments = arguments;
    }

    @Override
    protected <T> T visit(ExpressionVisitor<T> v) {
        return v.visit(this);
    }

    public InvocableExpression getTarget() {
        return this._method;
    }

    public List<Expression> getArguments() {
        return this._arguments;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this._arguments == null ? 0 : this._arguments.hashCode());
        result = 31 * result + (this._method == null ? 0 : this._method.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof InvocationExpression)) {
            return false;
        }
        InvocationExpression other = (InvocationExpression)obj;
        if (this._arguments == null ? other._arguments != null : !this._arguments.equals(other._arguments)) {
            return false;
        }
        return !(this._method == null ? other._method != null : !this._method.equals(other._method));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        InvocableExpression normalized = this._method;
        b.append(normalized.toString());
        if (normalized.getExpressionType() != 20) {
            b.append('(');
            List<ParameterExpression> parameters = normalized.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                if (i > 0) {
                    b.append(',');
                    b.append(' ');
                }
                b.append(this._arguments.get(parameters.get(i).getIndex()).toString());
            }
            b.append(')');
        }
        return b.toString();
    }
}

