/*
 * Decompiled with CFR 0.152.
 */
package com.trigersoft.jaque.expression;

import com.trigersoft.jaque.expression.Expression;
import com.trigersoft.jaque.expression.ExpressionVisitor;
import com.trigersoft.jaque.expression.InvocableExpression;
import com.trigersoft.jaque.expression.ParameterExpression;
import java.util.List;
import lombok.NonNull;

public final class DelegateExpression
extends InvocableExpression {
    private final Expression delegate;

    DelegateExpression(Class<?> resultType, @NonNull Expression delegate, List<ParameterExpression> params) {
        super(17, resultType, params);
        if (delegate == null) {
            throw new NullPointerException("delegate is marked @NonNull but is null");
        }
        if (!InvocableExpression.class.isAssignableFrom(delegate.getResultType())) {
            throw new IllegalArgumentException("delegate");
        }
        this.delegate = delegate;
    }

    @Override
    protected <T> T visit(ExpressionVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        b.append(this.getDelegate());
        b.append('}');
        return b.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DelegateExpression)) {
            return false;
        }
        DelegateExpression other = (DelegateExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Expression this$delegate = this.getDelegate();
        Expression other$delegate = other.getDelegate();
        return !(this$delegate == null ? other$delegate != null : !((Object)this$delegate).equals(other$delegate));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DelegateExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Expression $delegate = this.getDelegate();
        result = result * 59 + ($delegate == null ? 43 : ((Object)$delegate).hashCode());
        return result;
    }

    public Expression getDelegate() {
        return this.delegate;
    }
}

