/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.struct;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.NonNull;

public class CollectionInMap<K, V>
extends LinkedHashMap<K, Collection<V>> {
    private static final long serialVersionUID = 3068493190714636107L;
    private final Supplier<Collection<V>> supplier;

    public CollectionInMap() {
        this.supplier = LinkedList::new;
    }

    public CollectionInMap(Supplier<Collection<V>> supplier) {
        this.supplier = supplier;
    }

    public CollectionInMap(int initialCapacity, Supplier<Collection<V>> supplier) {
        super(initialCapacity);
        this.supplier = supplier;
    }

    public void putItem(K key, V item) {
        if (!this.containsKey(key)) {
            throw new IllegalStateException("key \"" + key + "\" is not exist.");
        }
        Collection collection = (Collection)this.get(key);
        collection.add(item);
    }

    public void putAllItem(K key, @NonNull Collection<V> items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        if (!this.containsKey(key)) {
            throw new IllegalStateException("key \"" + key + "\" is not exist.");
        }
        Collection collection = (Collection)this.get(key);
        collection.addAll(items);
    }

    public void putItemSoft(K key, V item) {
        if (this.containsKey(key)) {
            Collection collection = (Collection)this.get(key);
            collection.add(item);
        } else {
            Collection<V> collection = this.supplier.get();
            collection.add(item);
            this.put(key, collection);
        }
    }

    public void putAllItemSoft(K key, @NonNull Collection<V> items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        if (this.containsKey(key)) {
            Collection collection = (Collection)this.get(key);
            collection.addAll(items);
        } else {
            Collection<V> collection = this.supplier.get();
            collection.addAll(items);
            this.put(key, collection);
        }
    }

    public void removeItem(K key, V item) {
        if (!this.containsKey(key)) {
            throw new IllegalStateException("key \"" + key + "\" is not exist.");
        }
        Collection collection = (Collection)this.get(key);
        collection.remove(item);
    }

    public void removeIfItem(K key, @NonNull Predicate<? super V> filter) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        if (!this.containsKey(key)) {
            throw new IllegalStateException("key \"" + key + "\" is not exist.");
        }
        Collection collection = (Collection)this.get(key);
        collection.removeIf(filter);
    }
}

