/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import develop.toolkit.base.utils.JavaBeanUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public final class ObjectAdvice {
    @SafeVarargs
    public static <T> boolean valueIn(@NonNull T obj, T ... targets) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        for (T target : targets) {
            if (!obj.equals(target)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> boolean valueNotIn(@NonNull T obj, T ... targets) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        for (T target : targets) {
            if (!obj.equals(target)) continue;
            return false;
        }
        return true;
    }

    public static void set(Object instance, Field field, boolean firstUseSetterMethod) {
        if (firstUseSetterMethod) {
            try {
                String setterMethodName = JavaBeanUtils.getSetterMethodName(field.getName());
                MethodUtils.invokeMethod((Object)instance, (boolean)true, (String)setterMethodName);
            }
            catch (NoSuchMethodException e) {
                FieldUtils.writeField((Field)field, (Object)instance, (Object)true);
            }
        } else {
            FieldUtils.writeField((Field)field, (Object)instance, (Object)true);
        }
    }

    public static void set(Object instance, String fieldName, boolean firstUseSetterMethod) {
        if (firstUseSetterMethod) {
            try {
                String setterMethodName = JavaBeanUtils.getSetterMethodName(fieldName);
                MethodUtils.invokeMethod((Object)instance, (boolean)true, (String)setterMethodName);
            }
            catch (NoSuchMethodException e) {
                FieldUtils.writeField((Object)instance, (String)fieldName, (Object)true);
            }
        } else {
            FieldUtils.writeField((Object)instance, (String)fieldName, (Object)true);
        }
    }

    public static Object get(Object instance, Field field, boolean firstUseGetterMethod) {
        if (firstUseGetterMethod) {
            try {
                String getterMethodName = JavaBeanUtils.getGetterMethodName(field.getName(), field.getType());
                return MethodUtils.invokeMethod((Object)instance, (boolean)true, (String)getterMethodName);
            }
            catch (NoSuchMethodException e) {
                return FieldUtils.readField((Object)instance, (String)field.getName(), (boolean)true);
            }
        }
        return FieldUtils.readField((Object)instance, (String)field.getName(), (boolean)true);
    }

    public static Object get(Object instance, String fieldName, boolean firstUseGetterMethod) {
        if (firstUseGetterMethod) {
            try {
                Field field = instance.getClass().getField(fieldName);
                String getterMethodName = JavaBeanUtils.getGetterMethodName(fieldName, field.getType());
                return MethodUtils.invokeMethod((Object)instance, (boolean)true, (String)getterMethodName);
            }
            catch (NoSuchMethodException e) {
                return FieldUtils.readField((Object)instance, (String)fieldName, (boolean)true);
            }
        }
        return FieldUtils.readField((Object)instance, (String)fieldName, (boolean)true);
    }

    public static Map<Field, Object> readAllFieldValue(Object instance) {
        Field[] fields;
        HashMap<Field, Object> map = new HashMap<Field, Object>();
        for (Field field : fields = FieldUtils.getAllFields(instance.getClass())) {
            map.put(field, ObjectAdvice.get(instance, field, true));
        }
        return map;
    }

    public static <T> T newInstanceQuietly(Class<T> clazz) {
        return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static Object primitiveTypeCast(String value, Class<?> clazz) {
        if (value == null) {
            return null;
        }
        if (clazz == String.class) {
            return value;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return Integer.parseInt(value);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return Long.parseLong(value);
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return Double.parseDouble(value);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return Short.parseShort(value);
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return Character.valueOf(value.charAt(0));
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return Byte.parseByte(value);
        }
        throw new ClassCastException();
    }
}

