/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import develop.toolkit.base.struct.TwoValues;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringAdvice {
    public static boolean isEmpty(String content) {
        return content == null || content.isEmpty();
    }

    public static boolean isNotEmpty(String content) {
        return content != null && !content.isEmpty();
    }

    public static String defaultEmpty(String content) {
        return content != null ? content : "";
    }

    public static String emptyOr(String content, String defaultValue) {
        return StringAdvice.isEmpty(content) ? defaultValue : content;
    }

    public static String headTail(String content, String sign) {
        return sign + content + sign;
    }

    public static TwoValues<String, String> cutOff(String string, int index) {
        if (index > string.length() || index < 0) {
            return null;
        }
        return TwoValues.of(string.substring(0, index), string.substring(index));
    }

    public static String cutTail(String string, String tail) {
        return string.endsWith(tail) ? string.substring(0, string.length() - tail.length()) : string;
    }

    public static String cutHead(String string, String head) {
        return string.startsWith(head) ? string.substring(head.length()) : string;
    }

    public static List<String> regexMatch(String string, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(string);
        ArrayList<String> list = new ArrayList<String>(matcher.groupCount());
        while (matcher.find()) {
            list.add(matcher.group());
        }
        return list;
    }

    public static List<String> regexMatchStartEnd(String string, String start, String end) {
        return StringAdvice.regexMatch(string, String.format("(?<=%s)(.+?)(?=%s)", start, end));
    }
}

