/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.components;

import develop.toolkit.base.utils.DateTimeAdvice;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;

public final class BatchTask {
    private final int total;
    private int current;
    private long sumCostTime;
    private Instant start;

    public BatchTask(int total) {
        this.total = total;
    }

    public void start() {
        this.start = Instant.now();
        ++this.current;
    }

    public String finishOnce(String message) {
        if (this.current > this.total) {
            throw new IllegalStateException("The task have been finished.");
        }
        long costTime = this.start.until(Instant.now(), ChronoUnit.MILLIS);
        this.sumCostTime += costTime;
        long avgTime = this.sumCostTime / (long)this.current;
        long surplus = (long)(this.total - this.current) * avgTime;
        LocalDateTime finishTime = LocalDateTime.now().plusSeconds(surplus / 1000L);
        return String.format("%d/%d\t(%.02f%%) [cur: %s | avg: %s | sum: %s | sur: %s]\tfinish at: %s - %s", this.current, this.total, Float.valueOf((float)this.current / (float)this.total * 100.0f), DateTimeAdvice.millisecondPretty(costTime), DateTimeAdvice.millisecondPretty(avgTime), DateTimeAdvice.millisecondPretty(this.sumCostTime), DateTimeAdvice.millisecondPretty(surplus), DateTimeAdvice.format(finishTime), message);
    }

    public int getTotal() {
        return this.total;
    }

    public int getCurrent() {
        return this.current;
    }
}

