/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;

public final class JacksonAdvice {
    public static ObjectMapper defaultObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN});
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(dateTimeFormatter));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(dateTimeFormatter));
        objectMapper.registerModule((Module)javaTimeModule);
        return objectMapper;
    }

    public static String quickSerialize(Object object, boolean pretty) {
        if (pretty) {
            return JacksonAdvice.defaultObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        return JacksonAdvice.defaultObjectMapper().writeValueAsString(object);
    }

    public static <T> T quickDeserialize(String json, Class<T> clazz) {
        return (T)JacksonAdvice.defaultObjectMapper().readValue(json, clazz);
    }

    public static <T> T quickDeserializeArray(String json, Class<T> clazz) {
        ObjectMapper objectMapper = JacksonAdvice.defaultObjectMapper();
        ArrayType arrayType = objectMapper.getTypeFactory().constructArrayType(clazz);
        return (T)JacksonAdvice.defaultObjectMapper().readValue(json, (JavaType)arrayType);
    }

    public static <T> Collection<T> quickDeserializeCollection(String json, Class<T> clazz, Class<? extends Collection<?>> type) {
        ObjectMapper objectMapper = JacksonAdvice.defaultObjectMapper();
        CollectionType collectionType = objectMapper.getTypeFactory().constructCollectionType(type, clazz);
        return (Collection)JacksonAdvice.defaultObjectMapper().readValue(json, (JavaType)collectionType);
    }
}

