/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.github.dockerjava.core.SSLConfig;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class KeystoreSSLConfig
implements SSLConfig,
Serializable {
    private final KeyStore keystore;
    private final String keystorePassword;

    public KeystoreSSLConfig(KeyStore keystore, String keystorePassword) {
        this.keystorePassword = keystorePassword;
        Preconditions.checkNotNull((Object)keystore);
        this.keystore = keystore;
    }

    public KeystoreSSLConfig(File pfxFile, String password) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        Preconditions.checkNotNull((Object)pfxFile);
        Preconditions.checkNotNull((Object)password);
        this.keystore = KeyStore.getInstance("pkcs12");
        try (FileInputStream fs = new FileInputStream(pfxFile);){
            this.keystore.load(fs, password.toCharArray());
        }
        this.keystorePassword = password;
    }

    public SSLContext getSSLContext() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        SSLContext context = SSLContext.getInstance("TLS");
        String httpProtocols = System.getProperty("https.protocols");
        System.setProperty("https.protocols", "TLSv1");
        if (httpProtocols != null) {
            System.setProperty("https.protocols", httpProtocols);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(this.keystore, this.keystorePassword.toCharArray());
        context.init(keyManagerFactory.getKeyManagers(), new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
            }
        }}, new SecureRandom());
        return context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeystoreSSLConfig that = (KeystoreSSLConfig)o;
        return this.keystore.equals(that.keystore);
    }

    public int hashCode() {
        return this.keystore.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "keystore=" + this.keystore + "}";
    }
}

