/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.command;

import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.core.command.AbstrDockerCmd;
import com.github.dockerjava.core.util.FiltersBuilder;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ListImagesCmdImpl
extends AbstrDockerCmd<ListImagesCmd, List<Image>>
implements ListImagesCmd {
    private String imageNameFilter;
    private Boolean showAll = false;
    private FiltersBuilder filters = new FiltersBuilder();

    public ListImagesCmdImpl(ListImagesCmd.Exec exec) {
        super(exec);
    }

    public Map<String, List<String>> getFilters() {
        return this.filters.build();
    }

    public Boolean hasShowAllEnabled() {
        return this.showAll;
    }

    public ListImagesCmd withShowAll(Boolean showAll) {
        this.showAll = showAll;
        return this;
    }

    public ListImagesCmd withDanglingFilter(Boolean dangling) {
        Preconditions.checkNotNull((Object)dangling, (Object)"dangling have not been specified");
        this.withFilter("dangling", Collections.singletonList(dangling.toString()));
        return this;
    }

    public ListImagesCmd withLabelFilter(String ... labels) {
        Preconditions.checkNotNull((Object)labels, (Object)"labels have not been specified");
        this.filters.withLabels(labels);
        return this;
    }

    public ListImagesCmd withLabelFilter(Map<String, String> labels) {
        Preconditions.checkNotNull(labels, (Object)"labels have not been specified");
        this.filters.withLabels(labels);
        return this;
    }

    public ListImagesCmd withImageNameFilter(String imageNameFilter) {
        Preconditions.checkNotNull((Object)imageNameFilter, (Object)"image name filter not specified");
        this.imageNameFilter = imageNameFilter;
        return this;
    }

    public ListImagesCmd withReferenceFilter(String reference) {
        Preconditions.checkNotNull((Object)reference, (Object)"reference filter not specified");
        this.withFilter("reference", Collections.singletonList(reference));
        return this;
    }

    public ListImagesCmd withFilter(String key, Collection<String> values) {
        Preconditions.checkNotNull((Object)key, (Object)"key not specified");
        Preconditions.checkNotNull(values, (Object)"values not specified");
        this.filters.withFilter(key, values);
        return this;
    }

    public String getImageNameFilter() {
        return this.imageNameFilter;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

